/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.MeterFilterReply;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.ServiceLevelAgreementBoundary;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PropertiesMeterFilter
implements MeterFilter {
    private final MetricsProperties properties;
    private final MeterFilter mapFilter;

    public PropertiesMeterFilter(MetricsProperties properties) {
        Assert.notNull((Object)properties, (String)"Properties must not be null");
        this.properties = properties;
        this.mapFilter = PropertiesMeterFilter.createMapFilter(properties.getTags());
    }

    private static MeterFilter createMapFilter(Map<String, String> tags) {
        if (tags.isEmpty()) {
            return new MeterFilter(){};
        }
        Tags commonTags = Tags.of((Iterable)tags.entrySet().stream().map((? super T entry) -> Tag.of((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList()));
        return MeterFilter.commonTags((Iterable)commonTags);
    }

    public MeterFilterReply accept(Meter.Id id) {
        boolean enabled = this.lookup(this.properties.getEnable(), id, true);
        return enabled ? MeterFilterReply.NEUTRAL : MeterFilterReply.DENY;
    }

    public Meter.Id map(Meter.Id id) {
        return this.mapFilter.map(id);
    }

    public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
        MetricsProperties.Distribution distribution = this.properties.getDistribution();
        return DistributionStatisticConfig.builder().percentilesHistogram((Boolean)this.lookup(distribution.getPercentilesHistogram(), id, null)).percentiles((double[])this.lookup(distribution.getPercentiles(), id, null)).sla(this.convertSla(id.getType(), this.lookup(distribution.getSla(), id, null))).build().merge(config);
    }

    private long[] convertSla(Meter.Type meterType, ServiceLevelAgreementBoundary[] sla) {
        if (sla == null) {
            return null;
        }
        long[] converted = Arrays.stream(sla).map((? super T candidate) -> candidate.getValue(meterType)).filter(Objects::nonNull).mapToLong(Long::longValue).toArray();
        return (long[])(converted.length != 0 ? converted : null);
    }

    private <T> T lookup(Map<String, T> values, Meter.Id id, T defaultValue) {
        if (values.isEmpty()) {
            return defaultValue;
        }
        String name = id.getName();
        while (StringUtils.hasLength((String)name)) {
            T result = values.get(name);
            if (result != null) {
                return result;
            }
            int lastDot = name.lastIndexOf(46);
            name = lastDot != -1 ? name.substring(0, lastDot) : "";
        }
        return values.getOrDefault("all", defaultValue);
    }
}

