/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.liquibase;

import liquibase.integration.spring.SpringLiquibase;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnExposedEndpoint;
import org.springframework.boot.actuate.liquibase.LiquibaseEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.liquibase.DataSourceClosingSpringLiquibase;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SpringLiquibase.class})
@ConditionalOnEnabledEndpoint(endpoint=LiquibaseEndpoint.class)
@ConditionalOnExposedEndpoint(endpoint=LiquibaseEndpoint.class)
@AutoConfigureAfter(value={LiquibaseAutoConfiguration.class})
public class LiquibaseEndpointAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={SpringLiquibase.class})
    @ConditionalOnMissingBean
    public LiquibaseEndpoint liquibaseEndpoint(ApplicationContext context) {
        return new LiquibaseEndpoint(context);
    }

    @Bean
    @ConditionalOnBean(value={SpringLiquibase.class})
    public static BeanPostProcessor preventDataSourceCloseBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof DataSourceClosingSpringLiquibase) {
                    ((DataSourceClosingSpringLiquibase)bean).setCloseDataSourceOnceMigrated(false);
                }
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }
        };
    }
}

