/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.integration;

import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnExposedEndpoint;
import org.springframework.boot.actuate.integration.IntegrationGraphEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.integration.IntegrationAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.config.IntegrationConfigurationBeanFactoryPostProcessor;
import org.springframework.integration.graph.IntegrationGraphServer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={IntegrationGraphServer.class})
@ConditionalOnBean(value={IntegrationConfigurationBeanFactoryPostProcessor.class})
@ConditionalOnEnabledEndpoint(endpoint=IntegrationGraphEndpoint.class)
@ConditionalOnExposedEndpoint(endpoint=IntegrationGraphEndpoint.class)
@AutoConfigureAfter(value={IntegrationAutoConfiguration.class})
public class IntegrationGraphEndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public IntegrationGraphEndpoint integrationGraphEndpoint(IntegrationGraphServer integrationGraphServer) {
        return new IntegrationGraphEndpoint(integrationGraphServer);
    }

    @Bean
    @ConditionalOnMissingBean
    public IntegrationGraphServer integrationGraphServer() {
        return new IntegrationGraphServer();
    }
}

