/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.mongo;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthContributor;
import org.springframework.boot.actuate.mongo.MongoReactiveHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.mongo.MongoReactiveDataAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ReactiveMongoTemplate.class, Flux.class})
@ConditionalOnBean(value={ReactiveMongoTemplate.class})
@ConditionalOnEnabledHealthIndicator(value="mongo")
@AutoConfigureAfter(value={MongoReactiveDataAutoConfiguration.class})
public class MongoReactiveHealthContributorAutoConfiguration
extends CompositeReactiveHealthContributorConfiguration<MongoReactiveHealthIndicator, ReactiveMongoTemplate> {
    @Bean
    @ConditionalOnMissingBean(name={"mongoReactiveHealthIndicator", "mongoReactiveHealthContributor"})
    public ReactiveHealthContributor mongoReactiveHealthContributor(Map<String, ReactiveMongoTemplate> reactiveMongoTemplates) {
        return (ReactiveHealthContributor)this.createContributor(reactiveMongoTemplates);
    }
}

