/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import javax.servlet.Filter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerAdapter;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMapping;
import org.springframework.boot.actuate.properties.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerMapping;

@Configuration
public class EndpointWebMvcChildContextConfiguration
implements EmbeddedServletContainerCustomizer {
    @Autowired
    private ManagementServerProperties managementServerProperties;

    public void customize(ConfigurableEmbeddedServletContainerFactory factory) {
        factory.setPort(this.managementServerProperties.getPort().intValue());
        factory.setAddress(this.managementServerProperties.getAddress());
        factory.setContextPath(this.managementServerProperties.getContextPath());
    }

    @Bean
    public DispatcherServlet dispatcherServlet() {
        DispatcherServlet dispatcherServlet = new DispatcherServlet();
        dispatcherServlet.setDetectAllHandlerAdapters(false);
        dispatcherServlet.setDetectAllHandlerExceptionResolvers(false);
        dispatcherServlet.setDetectAllHandlerMappings(false);
        dispatcherServlet.setDetectAllViewResolvers(false);
        return dispatcherServlet;
    }

    @Bean
    public HandlerMapping handlerMapping() {
        return new EndpointHandlerMapping();
    }

    @Bean
    public HandlerAdapter handlerAdapter() {
        return new EndpointHandlerAdapter();
    }

    @Configuration
    @ConditionalOnClass(value={EnableWebSecurity.class, Filter.class})
    @ConditionalOnBean(name={"springSecurityFilterChain"}, search=SearchStrategy.PARENTS)
    public static class EndpointWebMvcChildContextSecurityConfiguration {
        @Bean
        public Filter springSecurityFilterChain(HierarchicalBeanFactory beanFactory) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            return (Filter)parent.getBean("springSecurityFilterChain", Filter.class);
        }
    }
}

