/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.web.BasicErrorController;
import org.springframework.boot.actuate.web.ErrorController;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.context.annotation.Bean;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.PropertyPlaceholderHelper;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.View;

@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@AutoConfigureBefore(value={WebMvcAutoConfiguration.class})
public class ErrorMvcAutoConfiguration
implements EmbeddedServletContainerCustomizer {
    @Value(value="${error.path:/error}")
    private String errorPath = "/error";
    private SpelView defaultErrorView = new SpelView("<html><body><h1>Whitelabel Error Page</h1><p>This application has no explicit mapping for /error, so you are seeing this as a fallback.</p><div id='created'>${timestamp}</div><div>There was an unexpected error (type=${error}, status=${status}).</div><div>${message}</div></body></html>");

    @Bean
    @ConditionalOnMissingBean(value={ErrorController.class})
    public BasicErrorController basicErrorController() {
        return new BasicErrorController();
    }

    public void customize(ConfigurableEmbeddedServletContainerFactory factory) {
        factory.addErrorPages(new ErrorPage[]{new ErrorPage(this.errorPath)});
    }

    @Bean(name={"error"})
    @ConditionalOnMissingBean(name={"error"})
    public View defaultErrorView() {
        return this.defaultErrorView;
    }

    private static class SpelView
    implements View {
        private final String template;
        private final SpelExpressionParser parser = new SpelExpressionParser();
        private final StandardEvaluationContext context = new StandardEvaluationContext();
        private PropertyPlaceholderHelper helper;
        private PropertyPlaceholderHelper.PlaceholderResolver resolver;

        public SpelView(String template) {
            this.template = template;
            this.context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
            this.helper = new PropertyPlaceholderHelper("${", "}");
            this.resolver = new PropertyPlaceholderHelper.PlaceholderResolver(){

                public String resolvePlaceholder(String name) {
                    Expression expression = SpelView.this.parser.parseExpression(name);
                    Object value = expression.getValue((EvaluationContext)SpelView.this.context);
                    return value == null ? null : value.toString();
                }
            };
        }

        public String getContentType() {
            return "text/html";
        }

        public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            if (response.getContentType() == null) {
                response.setContentType(this.getContentType());
            }
            HashMap map = new HashMap(model);
            map.put("path", request.getContextPath());
            this.context.setRootObject(map);
            String result = this.helper.replacePlaceholders(this.template, this.resolver);
            response.getWriter().append(result);
        }
    }
}

