/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.StopWatch;
import org.springframework.web.filter.GenericFilterBean;
import org.springframework.web.util.UrlPathHelper;

@Configuration
@ConditionalOnBean(value={CounterService.class, GaugeService.class})
@ConditionalOnClass(value={Servlet.class})
@AutoConfigureAfter(value={MetricRepositoryAutoConfiguration.class})
public class MetricFilterAutoConfiguration {
    private static final int UNDEFINED_HTTP_STATUS = 999;
    @Autowired
    private CounterService counterService;
    @Autowired
    private GaugeService gaugeService;

    @Bean
    public Filter metricFilter() {
        return new MetricsFilter();
    }

    @Order(value=-2147483648)
    private final class MetricsFilter
    extends GenericFilterBean {
        private MetricsFilter() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
                this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
            } else {
                chain.doFilter(request, response);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
            UrlPathHelper helper = new UrlPathHelper();
            String suffix = helper.getPathWithinApplication(request);
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            try {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                stopWatch.stop();
                String gaugeKey = this.getKey("response" + suffix);
                MetricFilterAutoConfiguration.this.gaugeService.set(gaugeKey, stopWatch.getTotalTimeMillis());
                String counterKey = this.getKey("status." + this.getStatus(response) + suffix);
                MetricFilterAutoConfiguration.this.counterService.increment(counterKey);
            }
        }

        private int getStatus(HttpServletResponse response) {
            try {
                return response.getStatus();
            }
            catch (Exception ex) {
                return 999;
            }
        }

        private String getKey(String string) {
            String value = string.replace("/", ".");
            if ((value = value.replace("..", ".")).endsWith(".")) {
                value = value + "root";
            }
            if (value.startsWith("_")) {
                value = value.substring(1);
            }
            return value;
        }
    }
}

