/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.DefaultCounterService;
import org.springframework.boot.actuate.metrics.DefaultGaugeService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.actuate.metrics.InMemoryMetricRepository;
import org.springframework.boot.actuate.metrics.MetricRepository;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MetricRepositoryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public CounterService counterService() {
        return new DefaultCounterService(this.metricRepository());
    }

    @Bean
    @ConditionalOnMissingBean
    public GaugeService gaugeService() {
        return new DefaultGaugeService(this.metricRepository());
    }

    @Bean
    @ConditionalOnMissingBean
    protected MetricRepository metricRepository() {
        return new InMemoryMetricRepository();
    }
}

