/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMapping;
import org.springframework.boot.actuate.properties.ManagementServerProperties;
import org.springframework.boot.actuate.properties.SecurityProperties;
import org.springframework.boot.actuate.web.ErrorController;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.HstsHeaderWriter;
import org.springframework.security.web.util.AnyRequestMatcher;
import org.springframework.security.web.util.RequestMatcher;

@Configuration
@ConditionalOnClass(value={EnableWebSecurity.class})
@EnableWebSecurity
@EnableConfigurationProperties
public class SecurityAutoConfiguration {
    @Bean(name={"org.springframework.actuate.properties.SecurityProperties"})
    @ConditionalOnMissingBean
    public SecurityProperties securityProperties() {
        return new SecurityProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthenticationEventPublisher authenticationEventPublisher() {
        return new DefaultAuthenticationEventPublisher();
    }

    @Bean
    @ConditionalOnMissingBean(value={ApplicationWebSecurityConfigurerAdapter.class})
    @ConditionalOnExpression(value="${security.basic.enabled:true}")
    public WebSecurityConfigurerAdapter applicationWebSecurityConfigurerAdapter() {
        return new ApplicationWebSecurityConfigurerAdapter();
    }

    @Bean
    @ConditionalOnMissingBean(value={ManagementWebSecurityConfigurerAdapter.class})
    public WebSecurityConfigurerAdapter managementWebSecurityConfigurerAdapter() {
        return new ManagementWebSecurityConfigurerAdapter();
    }

    private static void configureHeaders(HeadersConfigurer<?> configurer, SecurityProperties.Headers headers) throws Exception {
        if (headers.getHsts() != SecurityProperties.Headers.HSTS.none) {
            boolean includeSubdomains = headers.getHsts() == SecurityProperties.Headers.HSTS.all;
            HstsHeaderWriter writer = new HstsHeaderWriter(includeSubdomains);
            writer.setRequestMatcher((RequestMatcher)new AnyRequestMatcher());
            configurer.addHeaderWriter((HeaderWriter)writer);
        }
        if (headers.isContentType()) {
            configurer.contentTypeOptions();
        }
        if (headers.isXss()) {
            configurer.xssProtection();
        }
        if (headers.isCache()) {
            configurer.cacheControl();
        }
        if (headers.isFrame()) {
            configurer.frameOptions();
        }
    }

    @ConditionalOnMissingBean(value={AuthenticationManager.class})
    @Configuration
    public static class AuthenticationManagerConfiguration {
        private static Log logger = LogFactory.getLog(AuthenticationManagerConfiguration.class);
        @Autowired
        private SecurityProperties security;

        @Bean
        public AuthenticationManager authenticationManager() throws Exception {
            InMemoryUserDetailsManagerConfigurer builder = new AuthenticationManagerBuilder(ObjectPostProcessor.QUIESCENT_POSTPROCESSOR).inMemoryAuthentication();
            SecurityProperties.User user = this.security.getUser();
            if (user.isDefaultPassword()) {
                logger.info((Object)("Using default password for application endpoints: " + user.getPassword()));
            }
            LinkedHashSet<String> roles = new LinkedHashSet<String>(Arrays.asList(this.security.getManagement().getRole(), user.getRole()));
            builder.withUser(user.getName()).password(user.getPassword()).roles(roles.toArray(new String[roles.size()]));
            return (AuthenticationManager)((AuthenticationManagerBuilder)builder.and()).build();
        }
    }

    @Order(value=0x7FFFFFF5)
    private static class ManagementWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        private static final String[] NO_PATHS = new String[0];
        @Autowired
        private SecurityProperties security;
        @Autowired
        private ManagementServerProperties management;
        @Autowired(required=false)
        private EndpointHandlerMapping endpointHandlerMapping;

        private ManagementWebSecurityConfigurerAdapter() {
        }

        protected void configure(HttpSecurity http) throws Exception {
            String[] paths = this.getEndpointPaths(true);
            if (paths.length > 0 && this.security.getManagement().isEnabled()) {
                if (this.security.isRequireSsl()) {
                    ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresSecure();
                }
                http.exceptionHandling().authenticationEntryPoint(this.entryPoint());
                http.requestMatchers().antMatchers(paths);
                ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).hasRole(this.security.getManagement().getRole()).and()).httpBasic().and()).anonymous().disable();
                http.csrf().disable();
                http.sessionManagement().sessionCreationPolicy(this.security.getManagement().getSessions());
                SecurityAutoConfiguration.configureHeaders(http.headers(), this.security.getHeaders());
            }
        }

        public void configure(WebSecurity builder) throws Exception {
            WebSecurity.IgnoredRequestConfigurer ignoring = builder.ignoring();
            ignoring.antMatchers(this.getEndpointPaths(false));
        }

        private AuthenticationEntryPoint entryPoint() {
            BasicAuthenticationEntryPoint entryPoint = new BasicAuthenticationEntryPoint();
            entryPoint.setRealmName(this.security.getBasic().getRealm());
            return entryPoint;
        }

        private String[] getEndpointPaths(boolean secure) {
            if (this.endpointHandlerMapping == null) {
                return NO_PATHS;
            }
            List<Endpoint<?>> endpoints = this.endpointHandlerMapping.getEndpoints();
            ArrayList<String> paths = new ArrayList<String>(endpoints.size());
            for (Endpoint<?> endpoint : endpoints) {
                if (endpoint.isSensitive() != secure) continue;
                paths.add(endpoint.getPath());
            }
            return paths.toArray(new String[paths.size()]);
        }
    }

    @Order(value=0x7FFFFFFA)
    private static class ApplicationWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        private static List<String> DEFAULT_IGNORED = Arrays.asList("/css/**", "/js/**", "/images/**", "/**/favicon.ico");
        @Autowired
        private SecurityProperties security;
        @Autowired
        private AuthenticationEventPublisher authenticationEventPublisher;
        @Autowired(required=false)
        private ErrorController errorController;

        private ApplicationWebSecurityConfigurerAdapter() {
        }

        protected void configure(HttpSecurity http) throws Exception {
            if (this.security.isRequireSsl()) {
                ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresSecure();
            }
            String[] paths = this.getSecureApplicationPaths();
            if (this.security.getBasic().isEnabled() && paths.length > 0) {
                http.exceptionHandling().authenticationEntryPoint(this.entryPoint());
                http.requestMatchers().antMatchers(paths);
                ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).hasRole(this.security.getUser().getRole()).and()).httpBasic().and()).anonymous().disable();
            }
            if (!this.security.isEnableCsrf()) {
                http.csrf().disable();
            }
            http.sessionManagement().sessionCreationPolicy(this.security.getSessions());
            SecurityAutoConfiguration.configureHeaders(http.headers(), this.security.getHeaders());
        }

        private String[] getSecureApplicationPaths() {
            ArrayList<String> list = new ArrayList<String>();
            for (String path : this.security.getBasic().getPath()) {
                String string = path = path == null ? "" : path.trim();
                if (path.equals("/**")) {
                    return new String[]{path};
                }
                if (path.equals("")) continue;
                list.add(path);
            }
            return list.toArray(new String[list.size()]);
        }

        private AuthenticationEntryPoint entryPoint() {
            BasicAuthenticationEntryPoint entryPoint = new BasicAuthenticationEntryPoint();
            entryPoint.setRealmName(this.security.getBasic().getRealm());
            return entryPoint;
        }

        public void configure(WebSecurity builder) throws Exception {
            WebSecurity.IgnoredRequestConfigurer ignoring = builder.ignoring();
            ArrayList<String> ignored = new ArrayList<String>(this.security.getIgnored());
            if (ignored.isEmpty()) {
                ignored.addAll(DEFAULT_IGNORED);
            } else if (ignored.contains("none")) {
                ignored.remove("none");
            }
            if (this.errorController != null) {
                ignored.add(this.errorController.getErrorPath());
            }
            ignoring.antMatchers(ignored.toArray(new String[0]));
        }

        protected AuthenticationManager authenticationManager() throws Exception {
            AuthenticationManager manager = super.authenticationManager();
            if (manager instanceof ProviderManager) {
                ((ProviderManager)manager).setAuthenticationEventPublisher(this.authenticationEventPublisher);
            }
            return manager;
        }
    }
}

