/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

@ConfigurationProperties(name="endpoints.env", ignoreUnknownFields=false)
public class EnvironmentEndpoint
extends AbstractEndpoint<Map<String, Object>>
implements EnvironmentAware {
    private Environment environment;

    public EnvironmentEndpoint() {
        super("/env");
    }

    @Override
    public Map<String, Object> invoke() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (PropertySource<?> source : this.getPropertySources()) {
            if (!(source instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (String name : enumerable.getPropertyNames()) {
                map.put(name, this.sanitize(name, enumerable.getProperty(name)));
            }
            result.put(source.getName(), map);
        }
        return result;
    }

    private Iterable<PropertySource<?>> getPropertySources() {
        if (this.environment != null && this.environment instanceof ConfigurableEnvironment) {
            return ((ConfigurableEnvironment)this.environment).getPropertySources();
        }
        return new StandardEnvironment().getPropertySources();
    }

    private Object sanitize(String name, Object object) {
        if (name.toLowerCase().endsWith("password") || name.toLowerCase().endsWith("secret")) {
            return object == null ? null : "******";
        }
        return object;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

