/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics;

import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class Metric {
    private final String name;
    private final double value;

    public Metric(String name, double value) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public Metric increment(int amount) {
        return new Metric(this.name, new Double((int)this.value + amount));
    }

    public Metric set(double value) {
        return new Metric(this.name, value);
    }

    public String toString() {
        return "Metric [name=" + this.name + ", value=" + this.value + "]";
    }

    public int hashCode() {
        int valueHashCode = ObjectUtils.hashCode((double)this.value);
        int prime = 31;
        int result = 1;
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.name);
        result = 31 * result + (valueHashCode ^ valueHashCode >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            Metric other = (Metric)obj;
            boolean result = ObjectUtils.nullSafeEquals((Object)this.name, (Object)other.name);
            return result &= Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
        }
        return super.equals(obj);
    }
}

