/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;

@ConfigurationProperties(name="endpoints.configprops", ignoreUnknownFields=false)
public class ConfigurationPropertiesReportEndpoint
extends AbstractEndpoint<Map<String, Object>>
implements ApplicationContextAware {
    private String[] keysToSanitize = new String[]{"password", "secret"};
    private ApplicationContext context;

    public ConfigurationPropertiesReportEndpoint() {
        super("configprops");
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public String[] getKeysToSanitize() {
        return this.keysToSanitize;
    }

    public void setKeysToSanitize(String ... keysToSanitize) {
        Assert.notNull((Object)keysToSanitize, (String)"KeysToSanitize must not be null");
        this.keysToSanitize = keysToSanitize;
    }

    @Override
    public Map<String, Object> invoke() {
        Map<String, Object> beans = this.extract(this.context);
        return beans;
    }

    private Map<String, Object> extract(ApplicationContext context) {
        Map beans = context.getBeansWithAnnotation(ConfigurationProperties.class);
        ObjectMapper mapper = new ObjectMapper();
        for (Map.Entry entry : beans.entrySet()) {
            Map value = (Map)mapper.convertValue(entry.getValue(), Map.class);
            beans.put(entry.getKey(), this.sanitize(value));
        }
        if (context.getParent() != null) {
            beans.put("parent", this.extract(context.getParent()));
        }
        return beans;
    }

    private Map<String, Object> sanitize(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                map.put(entry.getKey(), this.sanitize((Map)entry.getValue()));
                continue;
            }
            map.put(entry.getKey(), this.sanitize(entry.getKey(), entry.getValue()));
        }
        return map;
    }

    private Object sanitize(String name, Object object) {
        for (String keyToSanitize : this.keysToSanitize) {
            if (!name.toLowerCase().endsWith(keyToSanitize)) continue;
            return object == null ? null : "******";
        }
        return object;
    }
}

