/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConfigurationProperties(name="endpoints.configprops", ignoreUnknownFields=false)
public class ConfigurationPropertiesReportEndpoint
extends AbstractEndpoint<Map<String, Object>>
implements ApplicationContextAware {
    private static final String CGLIB_FILTER_ID = "cglibFilter";
    private String[] keysToSanitize = new String[]{"password", "secret"};
    private ApplicationContext context;

    public ConfigurationPropertiesReportEndpoint() {
        super("configprops");
    }

    public String[] getKeysToSanitize() {
        return this.keysToSanitize;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void setKeysToSanitize(String ... keysToSanitize) {
        Assert.notNull((Object)keysToSanitize, (String)"KeysToSanitize must not be null");
        this.keysToSanitize = keysToSanitize;
    }

    @Override
    public Map<String, Object> invoke() {
        return this.extract(this.context);
    }

    protected Map<String, Object> extract(ApplicationContext context) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map beans = context.getBeansWithAnnotation(ConfigurationProperties.class);
        ObjectMapper mapper = new ObjectMapper();
        this.configureObjectMapper(mapper);
        for (Map.Entry entry : beans.entrySet()) {
            String beanName = (String)entry.getKey();
            Object bean = entry.getValue();
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("prefix", this.extractPrefix(bean));
            root.put("properties", this.sanitize((Map)mapper.convertValue(bean, Map.class)));
            result.put(beanName, root);
        }
        if (context.getParent() != null) {
            result.put("parent", this.extract(context.getParent()));
        }
        return result;
    }

    protected void configureObjectMapper(ObjectMapper mapper) {
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.applyCglibFilters(mapper);
    }

    private void applyCglibFilters(ObjectMapper mapper) {
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new CglibAnnotationIntrospector());
        mapper.setFilters((FilterProvider)new SimpleFilterProvider().addFilter(CGLIB_FILTER_ID, (SimpleBeanPropertyFilter)new CglibBeanPropertyFilter()));
    }

    private String extractPrefix(Object bean) {
        ConfigurationProperties annotation = (ConfigurationProperties)AnnotationUtils.findAnnotation(bean.getClass(), ConfigurationProperties.class);
        return StringUtils.hasLength((String)annotation.value()) ? annotation.value() : annotation.name();
    }

    private Map<String, Object> sanitize(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() instanceof Map) {
                map.put(entry.getKey(), this.sanitize((Map)entry.getValue()));
                continue;
            }
            map.put(entry.getKey(), this.sanitize(entry.getKey(), entry.getValue()));
        }
        return map;
    }

    private Object sanitize(String name, Object object) {
        for (String keyToSanitize : this.keysToSanitize) {
            if (!name.toLowerCase().endsWith(keyToSanitize)) continue;
            return object == null ? null : "******";
        }
        return object;
    }

    private static class CglibBeanPropertyFilter
    extends SimpleBeanPropertyFilter {
        private CglibBeanPropertyFilter() {
        }

        protected boolean include(BeanPropertyWriter writer) {
            return this.include(writer.getFullName().getSimpleName());
        }

        protected boolean include(PropertyWriter writer) {
            return this.include(writer.getFullName().getSimpleName());
        }

        private boolean include(String name) {
            return !name.startsWith("$$");
        }
    }

    private static class CglibAnnotationIntrospector
    extends JacksonAnnotationIntrospector {
        private CglibAnnotationIntrospector() {
        }

        public Object findFilterId(Annotated a) {
            Object id = super.findFilterId(a);
            if (id == null) {
                id = ConfigurationPropertiesReportEndpoint.CGLIB_FILTER_ID;
            }
            return id;
        }
    }
}

