/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.actuate.web.ErrorController;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.AuthenticationManagerConfiguration;
import org.springframework.boot.autoconfigure.security.FallbackWebSecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration;
import org.springframework.boot.autoconfigure.security.SecurityPrequisite;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.autoconfigure.security.SpringBootWebSecurityConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfiguration;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={EnableWebSecurity.class})
@AutoConfigureAfter(value={SecurityAutoConfiguration.class})
@AutoConfigureBefore(value={FallbackWebSecurityAutoConfiguration.class})
@EnableConfigurationProperties
public class ManagementSecurityAutoConfiguration {
    private static final String[] NO_PATHS = new String[0];

    @Bean
    @ConditionalOnMissingBean(value={IgnoredPathsWebSecurityConfigurerAdapter.class})
    public WebSecurityConfigurer<WebSecurity> ignoredPathsWebSecurityConfigurerAdapter() {
        return new IgnoredPathsWebSecurityConfigurerAdapter();
    }

    private static String[] getEndpointPaths(EndpointHandlerMapping endpointHandlerMapping, boolean secure) {
        if (endpointHandlerMapping == null) {
            return NO_PATHS;
        }
        Set<? extends MvcEndpoint> endpoints = endpointHandlerMapping.getEndpoints();
        ArrayList<String> paths = new ArrayList<String>(endpoints.size());
        for (MvcEndpoint mvcEndpoint : endpoints) {
            if (mvcEndpoint.isSensitive() != secure) continue;
            String path = endpointHandlerMapping.getPrefix() + mvcEndpoint.getPath();
            paths.add(path);
            if (!secure) continue;
            paths.add(path + "/");
            paths.add(path + ".*");
        }
        return paths.toArray(new String[paths.size()]);
    }

    @Configuration
    @ConditionalOnMissingBean(value={ManagementWebSecurityConfigurerAdapter.class})
    @ConditionalOnExpression(value="${management.security.enabled:true}")
    @ConditionalOnWebApplication
    @Order(value=0x7FFFFFF5)
    protected static class ManagementWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        @Autowired
        private SecurityProperties security;
        @Autowired
        private ManagementServerProperties management;
        @Autowired(required=false)
        private EndpointHandlerMapping endpointHandlerMapping;

        protected ManagementWebSecurityConfigurerAdapter() {
        }

        protected void configure(HttpSecurity http) throws Exception {
            String[] paths = ManagementSecurityAutoConfiguration.getEndpointPaths(this.endpointHandlerMapping, true);
            if (paths.length > 0 && this.management.getSecurity().isEnabled()) {
                if (this.security.isRequireSsl()) {
                    ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresSecure();
                }
                http.exceptionHandling().authenticationEntryPoint(this.entryPoint());
                http.requestMatchers().antMatchers(paths);
                ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).hasRole(this.management.getSecurity().getRole()).and()).httpBasic().and()).anonymous().disable();
                http.csrf().disable();
                http.sessionManagement().sessionCreationPolicy(this.management.getSecurity().getSessions());
                SpringBootWebSecurityConfiguration.configureHeaders((HeadersConfigurer)http.headers(), (SecurityProperties.Headers)this.security.getHeaders());
            }
        }

        private AuthenticationEntryPoint entryPoint() {
            BasicAuthenticationEntryPoint entryPoint = new BasicAuthenticationEntryPoint();
            entryPoint.setRealmName(this.security.getBasic().getRealm());
            return entryPoint;
        }
    }

    @Configuration
    @ConditionalOnExpression(value="${management.security.enabled:true} && !${security.basic.enabled:true}")
    @ConditionalOnMissingBean(value={WebSecurityConfiguration.class})
    @EnableWebSecurity
    protected static class WebSecurityEnabler
    extends AuthenticationManagerConfiguration {
        protected WebSecurityEnabler() {
        }
    }

    @Order(value=-2147483647)
    private static class IgnoredPathsWebSecurityConfigurerAdapter
    implements WebSecurityConfigurer<WebSecurity> {
        @Autowired(required=false)
        private ErrorController errorController;
        @Autowired(required=false)
        private EndpointHandlerMapping endpointHandlerMapping;
        @Autowired
        private ManagementServerProperties management;
        @Autowired
        private SecurityProperties security;

        private IgnoredPathsWebSecurityConfigurerAdapter() {
        }

        public void configure(WebSecurity builder) throws Exception {
        }

        public void init(WebSecurity builder) throws Exception {
            WebSecurity.IgnoredRequestConfigurer ignoring = builder.ignoring();
            List ignored = SpringBootWebSecurityConfiguration.getIgnored((SecurityProperties)this.security);
            ignored.addAll(Arrays.asList(ManagementSecurityAutoConfiguration.getEndpointPaths(this.endpointHandlerMapping, false)));
            if (!this.management.getSecurity().isEnabled()) {
                ignored.addAll(Arrays.asList(ManagementSecurityAutoConfiguration.getEndpointPaths(this.endpointHandlerMapping, true)));
            }
            if (ignored.contains("none")) {
                ignored.remove("none");
            }
            if (this.errorController != null) {
                ignored.add(this.normalizePath(this.errorController.getErrorPath()));
            }
            ignoring.antMatchers(ignored.toArray(new String[0]));
        }

        private String normalizePath(String errorPath) {
            String result = StringUtils.cleanPath((String)errorPath);
            if (!result.startsWith("/")) {
                result = "/" + result;
            }
            return result;
        }
    }

    @Configuration
    protected static class ManagementSecurityPropertiesConfiguration
    implements SecurityPrequisite {
        @Autowired(required=false)
        private SecurityProperties security;
        @Autowired(required=false)
        private ManagementServerProperties management;

        protected ManagementSecurityPropertiesConfiguration() {
        }

        @PostConstruct
        public void init() {
            if (this.management != null && this.security != null) {
                this.security.getUser().getRole().add(this.management.getSecurity().getRole());
            }
        }
    }
}

