/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class EndpointHandlerMapping
extends RequestMappingHandlerMapping
implements ApplicationContextAware {
    private final Set<? extends MvcEndpoint> endpoints;
    private String prefix = "";
    private boolean disabled = false;

    public EndpointHandlerMapping(Collection<? extends MvcEndpoint> endpoints) {
        this.endpoints = new HashSet<MvcEndpoint>(endpoints);
        this.setOrder(0x7FFFFFFD);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (!this.disabled) {
            for (MvcEndpoint mvcEndpoint : this.endpoints) {
                this.detectHandlerMethods(mvcEndpoint);
            }
        }
    }

    protected boolean isHandler(Class<?> beanType) {
        return false;
    }

    protected void registerHandlerMethod(Object handler, Method method, RequestMappingInfo mapping) {
        String prefix;
        if (mapping == null) {
            return;
        }
        Set defaultPatterns = mapping.getPatternsCondition().getPatterns();
        String[] patterns = new String[defaultPatterns.isEmpty() ? 1 : defaultPatterns.size()];
        String path = "";
        Object bean = handler;
        if (bean instanceof String) {
            bean = this.getApplicationContext().getBean((String)handler);
        }
        if (bean instanceof MvcEndpoint) {
            MvcEndpoint endpoint = (MvcEndpoint)bean;
            path = endpoint.getPath();
        }
        int i = 0;
        String string = prefix = StringUtils.hasText((String)this.prefix) ? this.prefix + path : path;
        if (defaultPatterns.isEmpty()) {
            patterns[0] = prefix;
        } else {
            for (String pattern : defaultPatterns) {
                patterns[i] = prefix + pattern;
                ++i;
            }
        }
        PatternsRequestCondition patternsInfo = new PatternsRequestCondition(patterns);
        RequestMappingInfo modified = new RequestMappingInfo(patternsInfo, mapping.getMethodsCondition(), mapping.getParamsCondition(), mapping.getHeadersCondition(), mapping.getConsumesCondition(), mapping.getProducesCondition(), mapping.getCustomCondition());
        super.registerHandlerMethod(handler, method, (Object)modified);
    }

    public void setPrefix(String prefix) {
        Assert.isTrue(("".equals(prefix) || StringUtils.startsWithIgnoreCase((String)prefix, (String)"/") ? 1 : 0) != 0, (String)"prefix must start with '/'");
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public Set<? extends MvcEndpoint> getEndpoints() {
        return this.endpoints;
    }
}

