/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

@ConfigurationProperties(prefix="endpoints.env", ignoreUnknownFields=false)
public class EnvironmentEndpoint
extends AbstractEndpoint<Map<String, Object>>
implements EnvironmentAware {
    private Environment environment;
    private String[] keysToSanitize = new String[]{"password", "secret", "key"};

    public EnvironmentEndpoint() {
        super("env");
    }

    public void setKeysToSanitize(String ... keysToSanitize) {
        Assert.notNull((Object)keysToSanitize, (String)"KeysToSanitize must not be null");
        this.keysToSanitize = keysToSanitize;
    }

    @Override
    public Map<String, Object> invoke() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("profiles", this.environment.getActiveProfiles());
        for (Map.Entry<String, PropertySource<?>> entry : this.getPropertySources().entrySet()) {
            PropertySource<?> source = entry.getValue();
            String sourceName = entry.getKey();
            if (!(source instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (String name : enumerable.getPropertyNames()) {
                map.put(name, this.sanitize(name, enumerable.getProperty(name)));
            }
            result.put(sourceName, map);
        }
        return result;
    }

    private Map<String, PropertySource<?>> getPropertySources() {
        LinkedHashMap map = new LinkedHashMap();
        MutablePropertySources sources = null;
        sources = this.environment != null && this.environment instanceof ConfigurableEnvironment ? ((ConfigurableEnvironment)this.environment).getPropertySources() : new StandardEnvironment().getPropertySources();
        for (PropertySource source : sources) {
            this.extract("", map, source);
        }
        return map;
    }

    private void extract(String root, Map<String, PropertySource<?>> map, PropertySource<?> source) {
        if (source instanceof CompositePropertySource) {
            Set<PropertySource<?>> nested = this.getNestedPropertySources((CompositePropertySource)source);
            for (PropertySource<?> nest : nested) {
                this.extract(source.getName() + ":", map, nest);
            }
        } else {
            map.put(root + source.getName(), source);
        }
    }

    private Set<PropertySource<?>> getNestedPropertySources(CompositePropertySource source) {
        try {
            Field field = ReflectionUtils.findField(CompositePropertySource.class, (String)"propertySources");
            field.setAccessible(true);
            return (Set)field.get(source);
        }
        catch (Exception ex) {
            return Collections.emptySet();
        }
    }

    public Object sanitize(String name, Object object) {
        for (String keyToSanitize : this.keysToSanitize) {
            if (!name.toLowerCase().endsWith(keyToSanitize)) continue;
            return object == null ? null : "******";
        }
        return object;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

