/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.solr.client.solrj.SolrServer;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.health.CompositeHealthIndicator;
import org.springframework.boot.actuate.health.DataSourceHealthIndicator;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.MongoHealthIndicator;
import org.springframework.boot.actuate.health.OrderedHealthAggregator;
import org.springframework.boot.actuate.health.RabbitHealthIndicator;
import org.springframework.boot.actuate.health.RedisHealthIndicator;
import org.springframework.boot.actuate.health.SolrHealthIndicator;
import org.springframework.boot.actuate.health.VanillaHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.solr.SolrAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
@AutoConfigureBefore(value={EndpointAutoConfiguration.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, MongoAutoConfiguration.class, MongoDataAutoConfiguration.class, RedisAutoConfiguration.class, RabbitAutoConfiguration.class, SolrAutoConfiguration.class})
public class HealthIndicatorAutoConfiguration {
    @Value(value="${health.status.order:}")
    private List<String> statusOrder = null;

    @Bean
    @ConditionalOnMissingBean
    public HealthAggregator healthAggregator() {
        OrderedHealthAggregator healthAggregator = new OrderedHealthAggregator();
        if (this.statusOrder != null) {
            healthAggregator.setStatusOrder(this.statusOrder);
        }
        return healthAggregator;
    }

    @Bean
    @ConditionalOnMissingBean(value={HealthIndicator.class})
    public HealthIndicator statusHealthIndicator() {
        return new VanillaHealthIndicator();
    }

    @Configuration
    @ConditionalOnBean(value={SolrServer.class})
    @ConditionalOnExpression(value="${health.solr.enabled:true}")
    public static class SolrHealthIndicatorConfiguration {
        @Autowired
        private HealthAggregator healthAggregator;
        @Autowired
        private Map<String, SolrServer> solrServers;

        @Bean
        @ConditionalOnMissingBean(name={"solrHealthIndicator"})
        public HealthIndicator rabbitHealthIndicator() {
            if (this.solrServers.size() == 1) {
                return new SolrHealthIndicator(this.solrServers.entrySet().iterator().next().getValue());
            }
            CompositeHealthIndicator composite = new CompositeHealthIndicator(this.healthAggregator);
            for (Map.Entry<String, SolrServer> entry : this.solrServers.entrySet()) {
                composite.addHealthIndicator(entry.getKey(), new SolrHealthIndicator(entry.getValue()));
            }
            return composite;
        }
    }

    @Configuration
    @ConditionalOnBean(value={RabbitTemplate.class})
    @ConditionalOnExpression(value="${health.rabbit.enabled:true}")
    public static class RabbitHealthIndicatorConfiguration {
        @Autowired
        private HealthAggregator healthAggregator;
        @Autowired
        private Map<String, RabbitTemplate> rabbitTemplates;

        @Bean
        @ConditionalOnMissingBean(name={"rabbitHealthIndicator"})
        public HealthIndicator rabbitHealthIndicator() {
            if (this.rabbitTemplates.size() == 1) {
                return new RabbitHealthIndicator(this.rabbitTemplates.values().iterator().next());
            }
            CompositeHealthIndicator composite = new CompositeHealthIndicator(this.healthAggregator);
            for (Map.Entry<String, RabbitTemplate> entry : this.rabbitTemplates.entrySet()) {
                composite.addHealthIndicator(entry.getKey(), new RabbitHealthIndicator(entry.getValue()));
            }
            return composite;
        }
    }

    @Configuration
    @ConditionalOnBean(value={RedisConnectionFactory.class})
    @ConditionalOnExpression(value="${health.redis.enabled:true}")
    public static class RedisHealthIndicatorConfiguration {
        @Autowired
        private HealthAggregator healthAggregator;
        @Autowired
        private Map<String, RedisConnectionFactory> redisConnectionFactories;

        @Bean
        @ConditionalOnMissingBean(name={"redisHealthIndicator"})
        public HealthIndicator redisHealthIndicator() {
            if (this.redisConnectionFactories.size() == 1) {
                return new RedisHealthIndicator(this.redisConnectionFactories.values().iterator().next());
            }
            CompositeHealthIndicator composite = new CompositeHealthIndicator(this.healthAggregator);
            for (Map.Entry<String, RedisConnectionFactory> entry : this.redisConnectionFactories.entrySet()) {
                composite.addHealthIndicator(entry.getKey(), new RedisHealthIndicator(entry.getValue()));
            }
            return composite;
        }
    }

    @Configuration
    @ConditionalOnBean(value={MongoTemplate.class})
    @ConditionalOnExpression(value="${health.mongo.enabled:true}")
    public static class MongoHealthIndicatorConfiguration {
        @Autowired
        private HealthAggregator healthAggregator;
        @Autowired
        private Map<String, MongoTemplate> mongoTemplates;

        @Bean
        @ConditionalOnMissingBean(name={"mongoHealthIndicator"})
        public HealthIndicator mongoHealthIndicator() {
            if (this.mongoTemplates.size() == 1) {
                return new MongoHealthIndicator(this.mongoTemplates.values().iterator().next());
            }
            CompositeHealthIndicator composite = new CompositeHealthIndicator(this.healthAggregator);
            for (Map.Entry<String, MongoTemplate> entry : this.mongoTemplates.entrySet()) {
                composite.addHealthIndicator(entry.getKey(), new MongoHealthIndicator(entry.getValue()));
            }
            return composite;
        }
    }

    @Configuration
    @ConditionalOnBean(value={DataSource.class})
    @ConditionalOnExpression(value="${health.db.enabled:true}")
    public static class DataSourcesHealthIndicatorConfiguration {
        @Autowired
        private HealthAggregator healthAggregator;
        @Autowired(required=false)
        private Map<String, DataSource> dataSources;

        @Bean
        @ConditionalOnMissingBean(name={"dbHealthIndicator"})
        public HealthIndicator dbHealthIndicator() {
            if (this.dataSources.size() == 1) {
                return new DataSourceHealthIndicator(this.dataSources.values().iterator().next());
            }
            CompositeHealthIndicator composite = new CompositeHealthIndicator(this.healthAggregator);
            for (Map.Entry<String, DataSource> entry : this.dataSources.entrySet()) {
                composite.addHealthIndicator(entry.getKey(), new DataSourceHealthIndicator(entry.getValue()));
            }
            return composite;
        }
    }
}

