/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public abstract class AbstractEndpoint<T>
implements Endpoint<T>,
EnvironmentAware {
    private static final String ENDPOINTS_ENABLED_PROPERTY = "endpoints.enabled";
    private Environment environment;
    @NotNull
    @Pattern(regexp="\\w+", message="ID must only contains letters, numbers and '_'")
    private String id;
    private boolean sensitive;
    private Boolean enabled;

    public AbstractEndpoint(String id) {
        this(id, true);
    }

    public AbstractEndpoint(String id, boolean sensitive) {
        this.id = id;
        this.sensitive = sensitive;
    }

    public AbstractEndpoint(String id, boolean sensitive, boolean enabled) {
        this.id = id;
        this.sensitive = sensitive;
        this.enabled = enabled;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public boolean isEnabled() {
        if (this.enabled != null) {
            return this.enabled;
        }
        if (this.environment != null) {
            this.environment.getProperty(ENDPOINTS_ENABLED_PROPERTY, Boolean.class, (Object)true);
        }
        return true;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isSensitive() {
        return this.sensitive;
    }

    public void setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
    }
}

