/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;

@ConfigurationProperties(prefix="endpoints.mappings", ignoreUnknownFields=false)
public class RequestMappingEndpoint
extends AbstractEndpoint<Map<String, Object>>
implements ApplicationContextAware {
    private List<AbstractUrlHandlerMapping> handlerMappings = Collections.emptyList();
    private List<AbstractHandlerMethodMapping<?>> methodMappings = Collections.emptyList();
    private ApplicationContext applicationContext;

    public RequestMappingEndpoint() {
        super("mappings");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setHandlerMappings(List<AbstractUrlHandlerMapping> handlerMappings) {
        this.handlerMappings = handlerMappings;
    }

    public void setMethodMappings(List<AbstractHandlerMethodMapping<?>> methodMappings) {
        this.methodMappings = methodMappings;
    }

    @Override
    public Map<String, Object> invoke() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.extractHandlerMappings(this.handlerMappings, result);
        this.extractHandlerMappings(this.applicationContext, result);
        this.extractMethodMappings(this.methodMappings, result);
        this.extractMethodMappings(this.applicationContext, result);
        return result;
    }

    protected void extractMethodMappings(ApplicationContext applicationContext, Map<String, Object> result) {
        if (applicationContext != null) {
            HashMap<String, Object> mappings = new HashMap<String, Object>();
            for (String name : applicationContext.getBeansOfType(AbstractHandlerMethodMapping.class).keySet()) {
                mappings.put(name, applicationContext.getBean(name, AbstractHandlerMethodMapping.class));
                Map methods = ((AbstractHandlerMethodMapping)applicationContext.getBean(name, AbstractHandlerMethodMapping.class)).getHandlerMethods();
                for (Object key : methods.keySet()) {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    map.put("bean", name);
                    map.put("method", ((HandlerMethod)methods.get(key)).toString());
                    result.put(key.toString(), map);
                }
            }
        }
    }

    protected void extractHandlerMappings(ApplicationContext applicationContext, Map<String, Object> result) {
        if (applicationContext != null) {
            Map mappings = applicationContext.getBeansOfType(AbstractUrlHandlerMapping.class);
            for (String name : mappings.keySet()) {
                AbstractUrlHandlerMapping mapping = (AbstractUrlHandlerMapping)mappings.get(name);
                Map<String, Object> handlers = this.getHandlerMap(mapping);
                for (String key : handlers.keySet()) {
                    result.put(key, Collections.singletonMap("bean", name));
                }
            }
        }
    }

    private Map<String, Object> getHandlerMap(AbstractUrlHandlerMapping mapping) {
        if (AopUtils.isCglibProxy((Object)mapping)) {
            return Collections.emptyMap();
        }
        return mapping.getHandlerMap();
    }

    protected void extractHandlerMappings(Collection<AbstractUrlHandlerMapping> handlerMappings, Map<String, Object> result) {
        for (AbstractUrlHandlerMapping mapping : handlerMappings) {
            Map handlers = mapping.getHandlerMap();
            for (Map.Entry entry : handlers.entrySet()) {
                Class<?> handlerClass = entry.getValue().getClass();
                result.put((String)entry.getKey(), Collections.singletonMap("type", handlerClass.getName()));
            }
        }
    }

    protected void extractMethodMappings(Collection<AbstractHandlerMethodMapping<?>> methodMappings, Map<String, Object> result) {
        for (AbstractHandlerMethodMapping<?> mapping : methodMappings) {
            Map methods = mapping.getHandlerMethods();
            for (Map.Entry entry : methods.entrySet()) {
                result.put(String.valueOf(entry.getKey()), Collections.singletonMap("method", String.valueOf(entry.getValue())));
            }
        }
    }
}

