/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.Properties;
import org.jolokia.http.AgentServlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.JolokiaProperties;
import org.springframework.boot.actuate.autoconfigure.ManagementSecurityAutoConfiguration;
import org.springframework.boot.actuate.endpoint.mvc.JolokiaMvcEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={AgentServlet.class})
@ConditionalOnProperty(prefix="endpoints.jolokia", name={"enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={ManagementSecurityAutoConfiguration.class})
@AutoConfigureAfter(value={EmbeddedServletContainerAutoConfiguration.class})
@EnableConfigurationProperties(value={JolokiaProperties.class})
public class JolokiaAutoConfiguration {
    @Autowired
    JolokiaProperties properties = new JolokiaProperties();

    @Bean
    @ConditionalOnMissingBean
    public JolokiaMvcEndpoint jolokiaEndpoint() {
        JolokiaMvcEndpoint endpoint = new JolokiaMvcEndpoint();
        endpoint.setInitParameters(this.getInitParameters());
        return endpoint;
    }

    private Properties getInitParameters() {
        Properties initParameters = new Properties();
        initParameters.putAll(this.properties.getConfig());
        return initParameters;
    }
}

