/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.trace;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.trace.Trace;
import org.springframework.boot.actuate.trace.TraceRepository;

public class InMemoryTraceRepository
implements TraceRepository {
    private int capacity = 100;
    private boolean reverse = true;
    private final List<Trace> traces = new LinkedList<Trace>();

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Trace> findAll() {
        List<Trace> list = this.traces;
        synchronized (list) {
            return Collections.unmodifiableList(this.traces);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Map<String, Object> map) {
        Trace trace = new Trace(new Date(), map);
        List<Trace> list = this.traces;
        synchronized (list) {
            while (this.traces.size() >= this.capacity) {
                this.traces.remove(this.reverse ? this.capacity - 1 : 0);
            }
            if (this.reverse) {
                this.traces.add(0, trace);
            } else {
                this.traces.add(trace);
            }
        }
    }
}

