/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.management.MBeanServer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.EndpointMBeanExportProperties;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBeanExporter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

@Configuration
@Conditional(value={JmxEnabledCondition.class})
@AutoConfigureAfter(value={EndpointAutoConfiguration.class, JmxAutoConfiguration.class})
@EnableConfigurationProperties(value={EndpointMBeanExportProperties.class})
public class EndpointMBeanExportAutoConfiguration {
    @Autowired
    private EndpointMBeanExportProperties properties = new EndpointMBeanExportProperties();
    @Autowired(required=false)
    private ObjectMapper objectMapper;

    @Bean
    public EndpointMBeanExporter endpointMBeanExporter(MBeanServer server) {
        EndpointMBeanExporter mbeanExporter = new EndpointMBeanExporter(this.objectMapper);
        String domain = this.properties.getDomain();
        if (StringUtils.hasText((String)domain)) {
            mbeanExporter.setDomain(domain);
        }
        mbeanExporter.setServer(server);
        mbeanExporter.setEnsureUniqueRuntimeObjectNames(this.properties.isUniqueNames());
        mbeanExporter.setObjectNameStaticProperties(this.properties.getStaticNames());
        return mbeanExporter;
    }

    @Bean
    @ConditionalOnMissingBean(value={MBeanServer.class})
    public MBeanServer mbeanServer() {
        return new JmxAutoConfiguration().mbeanServer();
    }

    static class JmxEnabledCondition
    extends SpringBootCondition {
        JmxEnabledCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            boolean jmxEnabled = this.isEnabled(context, "spring.jmx.");
            boolean jmxEndpointsEnabled = this.isEnabled(context, "endpoints.jmx.");
            return new ConditionOutcome(jmxEnabled && jmxEndpointsEnabled, "JMX Endpoints");
        }

        private boolean isEnabled(ConditionContext context, String prefix) {
            RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), prefix);
            return (Boolean)resolver.getProperty("enabled", Boolean.class, (Object)true);
        }
    }
}

