/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.ManagementContextConfigurationsImportSelector;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.actuate.autoconfigure.ManagementWebSecurityAutoConfiguration;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.mvc.ManagementErrorEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoints;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.ErrorAttributes;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@Configuration
@EnableWebMvc
@Import(value={ManagementContextConfigurationsImportSelector.class})
public class EndpointWebMvcChildContextConfiguration {
    private static Log logger = LogFactory.getLog(EndpointWebMvcChildContextConfiguration.class);
    @Value(value="${error.path:/error}")
    private String errorPath = "/error";
    @Autowired
    private ManagementServerProperties managementServerProperties;

    @Bean(name={"dispatcherServlet"})
    public DispatcherServlet dispatcherServlet() {
        DispatcherServlet dispatcherServlet = new DispatcherServlet();
        dispatcherServlet.setDetectAllHandlerAdapters(false);
        dispatcherServlet.setDetectAllHandlerExceptionResolvers(false);
        dispatcherServlet.setDetectAllHandlerMappings(false);
        dispatcherServlet.setDetectAllViewResolvers(false);
        return dispatcherServlet;
    }

    @Bean(name={"handlerMapping"})
    public CompositeHandlerMapping compositeHandlerMapping() {
        return new CompositeHandlerMapping();
    }

    @Bean(name={"handlerAdapter"})
    public CompositeHandlerAdapter compositeHandlerAdapter() {
        return new CompositeHandlerAdapter();
    }

    @Bean(name={"handlerExceptionResolver"})
    public CompositeHandlerExceptionResolver compositeHandlerExceptionResolver() {
        return new CompositeHandlerExceptionResolver();
    }

    @Bean
    public ServerCustomization serverCustomization() {
        return new ServerCustomization();
    }

    @Bean
    public ManagementErrorEndpoint errorEndpoint(ErrorAttributes errorAttributes) {
        return new ManagementErrorEndpoint(this.errorPath, errorAttributes);
    }

    static class CompositeHandlerExceptionResolver
    implements HandlerExceptionResolver {
        @Autowired
        private ListableBeanFactory beanFactory;
        private List<HandlerExceptionResolver> resolvers;

        CompositeHandlerExceptionResolver() {
        }

        private List<HandlerExceptionResolver> extractResolvers() {
            ArrayList<HandlerExceptionResolver> list = new ArrayList<HandlerExceptionResolver>();
            list.addAll(this.beanFactory.getBeansOfType(HandlerExceptionResolver.class).values());
            list.remove(this);
            AnnotationAwareOrderComparator.sort(list);
            return list;
        }

        public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
            if (this.resolvers == null) {
                this.resolvers = this.extractResolvers();
            }
            for (HandlerExceptionResolver mapping : this.resolvers) {
                ModelAndView mav = mapping.resolveException(request, response, handler, ex);
                if (mav == null) continue;
                return mav;
            }
            return null;
        }
    }

    static class CompositeHandlerAdapter
    implements HandlerAdapter {
        @Autowired
        private ListableBeanFactory beanFactory;
        private List<HandlerAdapter> adapters;

        CompositeHandlerAdapter() {
        }

        private List<HandlerAdapter> extractAdapters() {
            ArrayList<HandlerAdapter> list = new ArrayList<HandlerAdapter>();
            list.addAll(this.beanFactory.getBeansOfType(HandlerAdapter.class).values());
            list.remove(this);
            AnnotationAwareOrderComparator.sort(list);
            return list;
        }

        public boolean supports(Object handler) {
            if (this.adapters == null) {
                this.adapters = this.extractAdapters();
            }
            for (HandlerAdapter mapping : this.adapters) {
                if (!mapping.supports(handler)) continue;
                return true;
            }
            return false;
        }

        public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
            if (this.adapters == null) {
                this.adapters = this.extractAdapters();
            }
            for (HandlerAdapter mapping : this.adapters) {
                if (!mapping.supports(handler)) continue;
                return mapping.handle(request, response, handler);
            }
            return null;
        }

        public long getLastModified(HttpServletRequest request, Object handler) {
            if (this.adapters == null) {
                this.adapters = this.extractAdapters();
            }
            for (HandlerAdapter mapping : this.adapters) {
                if (!mapping.supports(handler)) continue;
                return mapping.getLastModified(request, handler);
            }
            return 0L;
        }
    }

    static class CompositeHandlerMapping
    implements HandlerMapping {
        @Autowired
        private ListableBeanFactory beanFactory;
        private List<HandlerMapping> mappings;

        CompositeHandlerMapping() {
        }

        public HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
            if (this.mappings == null) {
                this.mappings = this.extractMappings();
            }
            for (HandlerMapping mapping : this.mappings) {
                HandlerExecutionChain handler = mapping.getHandler(request);
                if (handler == null) continue;
                return handler;
            }
            return null;
        }

        private List<HandlerMapping> extractMappings() {
            ArrayList<HandlerMapping> list = new ArrayList<HandlerMapping>();
            list.addAll(this.beanFactory.getBeansOfType(HandlerMapping.class).values());
            list.remove(this);
            AnnotationAwareOrderComparator.sort(list);
            return list;
        }
    }

    static class ServerCustomization
    implements EmbeddedServletContainerCustomizer,
    Ordered {
        @Value(value="${error.path:/error}")
        private String errorPath = "/error";
        @Autowired
        private ListableBeanFactory beanFactory;
        private ManagementServerProperties managementServerProperties;
        private ServerProperties server;

        ServerCustomization() {
        }

        public int getOrder() {
            return 0;
        }

        public void customize(ConfigurableEmbeddedServletContainer container) {
            if (this.managementServerProperties == null) {
                this.managementServerProperties = (ManagementServerProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ManagementServerProperties.class);
                this.server = (ServerProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, ServerProperties.class);
            }
            this.server.customize(container);
            container.setErrorPages(Collections.emptySet());
            container.setPort(this.managementServerProperties.getPort().intValue());
            container.setAddress(this.managementServerProperties.getAddress());
            container.addErrorPages(new ErrorPage[]{new ErrorPage(this.errorPath)});
        }
    }

    @Configuration
    @ConditionalOnClass(value={EnableWebSecurity.class, Filter.class})
    @ConditionalOnBean(name={"springSecurityFilterChain"}, search=SearchStrategy.PARENTS)
    public static class EndpointWebMvcChildContextSecurityConfiguration {
        @Bean
        public Filter springSecurityFilterChain(HierarchicalBeanFactory beanFactory) {
            BeanFactory parent = beanFactory.getParentBeanFactory();
            return (Filter)parent.getBean("springSecurityFilterChain", Filter.class);
        }
    }

    @Configuration
    @ConditionalOnClass(value={WebSecurityConfigurerAdapter.class})
    protected static class SecureEndpointHandlerMappingConfiguration
    extends EndpointHandlerMappingConfiguration {
        protected SecureEndpointHandlerMappingConfiguration() {
        }

        @Override
        protected void postProcessMapping(ListableBeanFactory beanFactory, EndpointHandlerMapping mapping) {
            if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, ManagementWebSecurityAutoConfiguration.ManagementWebSecurityConfigurerAdapter.class).length == 1) {
                ManagementWebSecurityAutoConfiguration.ManagementWebSecurityConfigurerAdapter bean = (ManagementWebSecurityAutoConfiguration.ManagementWebSecurityConfigurerAdapter)((Object)beanFactory.getBean(ManagementWebSecurityAutoConfiguration.ManagementWebSecurityConfigurerAdapter.class));
                bean.setEndpointHandlerMapping(mapping);
            } else {
                logger.warn((Object)("No single bean of type " + ManagementWebSecurityAutoConfiguration.ManagementWebSecurityConfigurerAdapter.class.getSimpleName() + " found (this might make some endpoints inaccessible without authentication)"));
            }
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter"})
    protected static class EndpointHandlerMappingConfiguration {
        protected EndpointHandlerMappingConfiguration() {
        }

        @Autowired
        public void handlerMapping(MvcEndpoints endpoints, ListableBeanFactory beanFactory, EndpointHandlerMapping mapping) {
            mapping.setDetectHandlerMethodsInAncestorContexts(true);
            this.postProcessMapping(beanFactory, mapping);
        }

        protected void postProcessMapping(ListableBeanFactory beanFactory, EndpointHandlerMapping mapping) {
        }
    }
}

