/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.cache;

import net.sf.ehcache.statistics.StatisticsGateway;
import org.springframework.boot.actuate.cache.CacheStatistics;
import org.springframework.boot.actuate.cache.CacheStatisticsProvider;
import org.springframework.boot.actuate.cache.DefaultCacheStatistics;
import org.springframework.cache.CacheManager;
import org.springframework.cache.ehcache.EhCacheCache;

public class EhCacheStatisticsProvider
implements CacheStatisticsProvider<EhCacheCache> {
    @Override
    public CacheStatistics getCacheStatistics(CacheManager cacheManager, EhCacheCache cache) {
        DefaultCacheStatistics statistics = new DefaultCacheStatistics();
        StatisticsGateway ehCacheStatistics = cache.getNativeCache().getStatistics();
        statistics.setSize(ehCacheStatistics.getSize());
        Double hitRatio = ehCacheStatistics.cacheHitRatio();
        if (!hitRatio.isNaN()) {
            double sanitizedHitRatio = hitRatio > 1.0 ? 1.0 : hitRatio;
            statistics.setHitRatio(sanitizedHitRatio);
            statistics.setMissRatio(1.0 - sanitizedHitRatio);
        }
        return statistics;
    }
}

