/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

abstract class NamePatternFilter<T> {
    private static final String[] REGEX_PARTS = new String[]{"*", "$", "^", "+"};
    private final T source;

    public NamePatternFilter(T source) {
        this.source = source;
    }

    public Object getResults(String name) {
        if (!this.isRegex(name)) {
            return this.getValue(this.source, name);
        }
        Pattern pattern = Pattern.compile(name);
        ResultCollectingNameCallback resultCollector = new ResultCollectingNameCallback(pattern);
        this.getNames(this.source, resultCollector);
        return resultCollector.getResults();
    }

    private boolean isRegex(String name) {
        for (String part : REGEX_PARTS) {
            if (!name.contains(part)) continue;
            return true;
        }
        return false;
    }

    protected abstract void getNames(T var1, NameCallback var2);

    protected abstract Object getValue(T var1, String var2);

    private class ResultCollectingNameCallback
    implements NameCallback {
        private final Pattern pattern;
        private final Map<String, Object> results = new LinkedHashMap<String, Object>();

        public ResultCollectingNameCallback(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public void addName(String name) {
            if (this.pattern.matcher(name).matches()) {
                this.results.put(name, NamePatternFilter.this.getValue(NamePatternFilter.this.source, name));
            }
        }

        public Map<String, Object> getResults() {
            return this.results;
        }
    }

    protected static interface NameCallback {
        public void addName(String var1);
    }
}

