/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import java.io.File;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(value="management.health.diskspace")
public class DiskSpaceHealthIndicatorProperties {
    private static final int MEGABYTES = 0x100000;
    private static final int DEFAULT_THRESHOLD = 0xA00000;
    private File path = new File(".");
    private long threshold = 0xA00000L;

    public File getPath() {
        return this.path;
    }

    public void setPath(File path) {
        Assert.isTrue((boolean)path.exists(), (String)("Path '" + path + "' does not exist"));
        Assert.isTrue((boolean)path.canRead(), (String)("Path '" + path + "' cannot be read"));
        this.path = path;
    }

    public long getThreshold() {
        return this.threshold;
    }

    public void setThreshold(long threshold) {
        Assert.isTrue((threshold >= 0L ? 1 : 0) != 0, (String)"threshold must be greater than 0");
        this.threshold = threshold;
    }
}

