/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.export;

import java.io.Flushable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.export.AbstractMetricExporter;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.boot.actuate.metrics.writer.CompositeMetricWriter;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.ReflectionUtils;

public class MetricCopyExporter
extends AbstractMetricExporter {
    private static final Log logger = LogFactory.getLog(MetricCopyExporter.class);
    private final MetricReader reader;
    private final MetricWriter writer;
    private String[] includes = new String[0];
    private String[] excludes = new String[0];

    public MetricCopyExporter(MetricReader reader, MetricWriter writer) {
        this(reader, writer, "");
    }

    public MetricCopyExporter(MetricReader reader, MetricWriter writer, String prefix) {
        super(prefix);
        this.reader = reader;
        this.writer = writer;
    }

    public void setIncludes(String ... includes) {
        if (includes != null) {
            this.includes = includes;
        }
    }

    public void setExcludes(String ... excludes) {
        if (excludes != null) {
            this.excludes = excludes;
        }
    }

    @Override
    protected Iterable<Metric<?>> next(String group) {
        if (ObjectUtils.isEmpty((Object[])this.includes) && ObjectUtils.isEmpty((Object[])this.excludes)) {
            return this.reader.findAll();
        }
        return new PatternMatchingIterable(this.reader);
    }

    @Override
    protected void write(String group, Collection<Metric<?>> values) {
        for (Metric<?> value : values) {
            this.writer.set(value);
        }
    }

    @Override
    public void flush() {
        this.flush(this.writer);
    }

    private void flush(MetricWriter writer) {
        if (writer instanceof CompositeMetricWriter) {
            for (MetricWriter child : (CompositeMetricWriter)writer) {
                this.flush(child);
            }
        }
        try {
            if (ClassUtils.isPresent((String)"java.io.Flushable", null) && writer instanceof Flushable) {
                ((Flushable)((Object)writer)).flush();
                return;
            }
            Method method = ReflectionUtils.findMethod(writer.getClass(), (String)"flush");
            if (method != null) {
                ReflectionUtils.invokeMethod((Method)method, (Object)writer);
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("Could not flush MetricWriter: " + ex.getClass() + ": " + ex.getMessage()));
        }
    }

    private class PatternMatchingIterator
    implements Iterator<Metric<?>> {
        private Metric<?> buffer = null;
        private Iterator<Metric<?>> iterator;

        public PatternMatchingIterator(Iterator<Metric<?>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (this.buffer != null) {
                return true;
            }
            this.buffer = this.findNext();
            return this.buffer != null;
        }

        private Metric<?> findNext() {
            while (this.iterator.hasNext()) {
                Metric<?> metric = this.iterator.next();
                if (!this.isMatch(metric)) continue;
                return metric;
            }
            return null;
        }

        private boolean isMatch(Metric<?> metric) {
            Object[] includes = MetricCopyExporter.this.includes;
            String[] excludes = MetricCopyExporter.this.excludes;
            String name = metric.getName();
            if (ObjectUtils.isEmpty((Object[])includes) || PatternMatchUtils.simpleMatch((String[])includes, (String)name)) {
                return !PatternMatchUtils.simpleMatch((String[])excludes, (String)name);
            }
            return false;
        }

        @Override
        public Metric<?> next() {
            Metric<?> metric = this.buffer;
            this.buffer = null;
            return metric;
        }
    }

    private class PatternMatchingIterable
    implements Iterable<Metric<?>> {
        private final MetricReader reader;

        public PatternMatchingIterable(MetricReader reader) {
            this.reader = reader;
        }

        @Override
        public Iterator<Metric<?>> iterator() {
            return new PatternMatchingIterator(this.reader.findAll().iterator());
        }
    }
}

