/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.integration;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.integration.monitor.IntegrationMBeanExporter;
import org.springframework.integration.support.management.Statistics;
import org.springframework.lang.UsesJava7;

@UsesJava7
public class SpringIntegrationMetricReader
implements MetricReader {
    private final IntegrationMBeanExporter exporter;

    public SpringIntegrationMetricReader(IntegrationMBeanExporter exporter) {
        this.exporter = exporter;
    }

    @Override
    public Metric<?> findOne(String metricName) {
        return null;
    }

    @Override
    public Iterable<Metric<?>> findAll() {
        IntegrationMBeanExporter exporter = this.exporter;
        ArrayList metrics = new ArrayList();
        for (String name : exporter.getChannelNames()) {
            String prefix = "integration.channel." + name;
            metrics.addAll(this.getStatistics(prefix + ".errorRate", exporter.getChannelErrorRate(name)));
            metrics.add(new Metric<Integer>(prefix + ".sendCount", exporter.getChannelSendCount(name)));
            metrics.addAll(this.getStatistics(prefix + ".sendRate", exporter.getChannelSendRate(name)));
            metrics.add(new Metric<Long>(prefix + ".receiveCount", exporter.getChannelReceiveCountLong(name)));
        }
        for (String name : exporter.getHandlerNames()) {
            metrics.addAll(this.getStatistics("integration.handler." + name + ".duration", exporter.getHandlerDuration(name)));
        }
        metrics.add(new Metric<Long>("integration.activeHandlerCount", exporter.getActiveHandlerCountLong()));
        metrics.add(new Metric<Integer>("integration.handlerCount", exporter.getHandlerCount()));
        metrics.add(new Metric<Integer>("integration.channelCount", exporter.getChannelCount()));
        metrics.add(new Metric<Integer>("integration.queuedMessageCount", exporter.getQueuedMessageCount()));
        return metrics;
    }

    private Collection<? extends Metric<?>> getStatistics(String name, Statistics statistic) {
        ArrayList<Metric<Number>> metrics = new ArrayList<Metric<Number>>();
        metrics.add(new Metric<Double>(name + ".mean", statistic.getMean()));
        metrics.add(new Metric<Double>(name + ".max", statistic.getMax()));
        metrics.add(new Metric<Double>(name + ".min", statistic.getMin()));
        metrics.add(new Metric<Double>(name + ".stdev", statistic.getStandardDeviation()));
        metrics.add(new Metric<Long>(name + ".count", statistic.getCountLong()));
        return metrics;
    }

    @Override
    public long count() {
        int totalChannelCount = this.exporter.getChannelCount() * 11;
        int totalHandlerCount = this.exporter.getHandlerCount() * 5;
        return totalChannelCount + totalHandlerCount + 4;
    }
}

