/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.opentsdb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.opentsdb.DefaultOpenTsdbNamingStrategy;
import org.springframework.boot.actuate.metrics.opentsdb.OpenTsdbData;
import org.springframework.boot.actuate.metrics.opentsdb.OpenTsdbNamingStrategy;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class OpenTsdbMetricWriter
implements MetricWriter {
    private static final Log logger = LogFactory.getLog(OpenTsdbMetricWriter.class);
    private RestOperations restTemplate = new RestTemplate();
    private String url = "http://localhost:4242/api/put";
    private int bufferSize = 64;
    private MediaType mediaType = MediaType.APPLICATION_JSON;
    private List<OpenTsdbData> buffer = new ArrayList<OpenTsdbData>(this.bufferSize);
    private OpenTsdbNamingStrategy namingStrategy = new DefaultOpenTsdbNamingStrategy();

    public RestOperations getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void setNamingStrategy(OpenTsdbNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    @Override
    public void increment(Delta<?> delta) {
        throw new UnsupportedOperationException("Counters not supported via increment");
    }

    @Override
    public void set(Metric<?> value) {
        OpenTsdbData data = new OpenTsdbData(this.namingStrategy.getName(value.getName()), (Number)value.getValue(), (Long)value.getTimestamp().getTime());
        this.buffer.add(data);
        if (this.buffer.size() >= this.bufferSize) {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.buffer.isEmpty()) {
            return;
        }
        ArrayList<OpenTsdbData> temp = new ArrayList<OpenTsdbData>();
        List<OpenTsdbData> list = this.buffer;
        synchronized (list) {
            temp.addAll(this.buffer);
            this.buffer.clear();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(this.mediaType));
        headers.setContentType(this.mediaType);
        HttpEntity request = new HttpEntity(temp, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.url, (Object)request, Map.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            logger.warn((Object)("Cannot write metrics (discarded " + temp.size() + " values): " + response.getBody()));
        }
    }

    @Override
    public void reset(String metricName) {
        this.set(new Metric<Long>(metricName, 0L));
    }
}

