/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.regex.Pattern;
import org.springframework.util.Assert;

class Sanitizer {
    private static final String[] REGEX_PARTS = new String[]{"*", "$", "^", "+"};
    private Pattern[] keysToSanitize;

    public Sanitizer() {
        this.setKeysToSanitize("password", "secret", "key", ".*credentials.*", "vcap_services");
    }

    public void setKeysToSanitize(String ... keysToSanitize) {
        Assert.notNull((Object)keysToSanitize, (String)"KeysToSanitize must not be null");
        this.keysToSanitize = new Pattern[keysToSanitize.length];
        for (int i = 0; i < keysToSanitize.length; ++i) {
            this.keysToSanitize[i] = this.getPattern(keysToSanitize[i]);
        }
    }

    private Pattern getPattern(String value) {
        if (this.isRegex(value)) {
            return Pattern.compile(value, 2);
        }
        return Pattern.compile(".*" + value + "$", 2);
    }

    private boolean isRegex(String value) {
        for (String part : REGEX_PARTS) {
            if (!value.contains(part)) continue;
            return true;
        }
        return false;
    }

    public Object sanitize(String key, Object value) {
        for (Pattern pattern : this.keysToSanitize) {
            if (!pattern.matcher(key).matches()) continue;
            return value == null ? null : "******";
        }
        return value;
    }
}

