/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.export;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.actuate.metrics.export.Exporter;
import org.springframework.boot.actuate.metrics.export.MetricCopyExporter;
import org.springframework.boot.actuate.metrics.export.MetricExportProperties;
import org.springframework.boot.actuate.metrics.export.TriggerProperties;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.IntervalTask;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

public class MetricExporters
implements SchedulingConfigurer {
    private MetricReader reader;
    private Map<String, MetricWriter> writers = new HashMap<String, MetricWriter>();
    private final MetricExportProperties properties;
    private final Map<String, Exporter> exporters = new HashMap<String, Exporter>();

    public MetricExporters(MetricExportProperties properties) {
        this.properties = properties;
    }

    public void setReader(MetricReader reader) {
        this.reader = reader;
    }

    public void setWriters(Map<String, MetricWriter> writers) {
        this.writers.putAll(writers);
    }

    public void setExporters(Map<String, Exporter> exporters) {
        this.exporters.putAll(exporters);
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        TriggerProperties trigger;
        String name;
        for (Map.Entry<String, Exporter> entry : this.exporters.entrySet()) {
            name = entry.getKey();
            Exporter exporter = entry.getValue();
            trigger = this.properties.findTrigger(name);
            if (trigger == null) continue;
            ExportRunner runner = new ExportRunner(exporter);
            IntervalTask task = new IntervalTask((Runnable)runner, trigger.getDelayMillis().longValue(), trigger.getDelayMillis().longValue());
            taskRegistrar.addFixedDelayTask(task);
        }
        for (Map.Entry<String, Object> entry : this.writers.entrySet()) {
            name = entry.getKey();
            MetricWriter writer = (MetricWriter)entry.getValue();
            trigger = this.properties.findTrigger(name);
            if (trigger == null) continue;
            MetricCopyExporter exporter = this.getExporter(writer, trigger);
            this.exporters.put(name, exporter);
            ExportRunner runner = new ExportRunner(exporter);
            IntervalTask task = new IntervalTask((Runnable)runner, trigger.getDelayMillis().longValue(), trigger.getDelayMillis().longValue());
            taskRegistrar.addFixedDelayTask(task);
        }
    }

    private MetricCopyExporter getExporter(MetricWriter writer, TriggerProperties trigger) {
        MetricCopyExporter exporter = new MetricCopyExporter(this.reader, writer);
        exporter.setIncludes(trigger.getIncludes());
        exporter.setExcludes(trigger.getExcludes());
        exporter.setSendLatest(trigger.isSendLatest());
        return exporter;
    }

    public Map<String, Exporter> getExporters() {
        return this.exporters;
    }

    private static class ExportRunner
    implements Runnable {
        private final Exporter exporter;

        public ExportRunner(Exporter exporter) {
            this.exporter = exporter;
        }

        @Override
        public void run() {
            this.exporter.export();
        }
    }
}

