/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.EndpointCorsProperties;
import org.springframework.boot.actuate.autoconfigure.HealthMvcEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.actuate.endpoint.EnvironmentEndpoint;
import org.springframework.boot.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.actuate.endpoint.MetricsEndpoint;
import org.springframework.boot.actuate.endpoint.ShutdownEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.mvc.EndpointHandlerMappingCustomizer;
import org.springframework.boot.actuate.endpoint.mvc.EnvironmentMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.HealthMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.LogFileMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MetricsMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoints;
import org.springframework.boot.actuate.endpoint.mvc.ShutdownMvcEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;

@ManagementContextConfiguration
@EnableConfigurationProperties(value={HealthMvcEndpointProperties.class, EndpointCorsProperties.class})
public class EndpointWebMvcManagementContextConfiguration {
    @Autowired
    private HealthMvcEndpointProperties healthMvcEndpointProperties;
    @Autowired
    private ManagementServerProperties managementServerProperties;
    @Autowired
    private EndpointCorsProperties corsProperties;
    @Autowired(required=false)
    private List<EndpointHandlerMappingCustomizer> mappingCustomizers;

    @Bean
    @ConditionalOnMissingBean
    public EndpointHandlerMapping endpointHandlerMapping() {
        Set<? extends MvcEndpoint> endpoints = this.mvcEndpoints().getEndpoints();
        CorsConfiguration corsConfiguration = this.getCorsConfiguration(this.corsProperties);
        EndpointHandlerMapping mapping = new EndpointHandlerMapping(endpoints, corsConfiguration);
        boolean disabled = this.managementServerProperties.getPort() != null && this.managementServerProperties.getPort() == -1;
        mapping.setDisabled(disabled);
        if (!disabled) {
            mapping.setPrefix(this.managementServerProperties.getContextPath());
        }
        if (this.mappingCustomizers != null) {
            for (EndpointHandlerMappingCustomizer customizer : this.mappingCustomizers) {
                customizer.customize(mapping);
            }
        }
        return mapping;
    }

    private CorsConfiguration getCorsConfiguration(EndpointCorsProperties properties) {
        if (CollectionUtils.isEmpty(properties.getAllowedOrigins())) {
            return null;
        }
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(properties.getAllowedOrigins());
        if (!CollectionUtils.isEmpty(properties.getAllowedHeaders())) {
            configuration.setAllowedHeaders(properties.getAllowedHeaders());
        }
        if (!CollectionUtils.isEmpty(properties.getAllowedMethods())) {
            configuration.setAllowedMethods(properties.getAllowedMethods());
        }
        if (!CollectionUtils.isEmpty(properties.getExposedHeaders())) {
            configuration.setExposedHeaders(properties.getExposedHeaders());
        }
        if (properties.getMaxAge() != null) {
            configuration.setMaxAge(properties.getMaxAge());
        }
        if (properties.getAllowCredentials() != null) {
            configuration.setAllowCredentials(properties.getAllowCredentials());
        }
        return configuration;
    }

    @Bean
    @ConditionalOnMissingBean
    public MvcEndpoints mvcEndpoints() {
        return new MvcEndpoints();
    }

    @Bean
    @ConditionalOnBean(value={EnvironmentEndpoint.class})
    @ConditionalOnEnabledEndpoint(value="env")
    public EnvironmentMvcEndpoint environmentMvcEndpoint(EnvironmentEndpoint delegate) {
        return new EnvironmentMvcEndpoint(delegate);
    }

    @Bean
    @ConditionalOnBean(value={HealthEndpoint.class})
    @ConditionalOnEnabledEndpoint(value="health")
    public HealthMvcEndpoint healthMvcEndpoint(HealthEndpoint delegate) {
        ManagementServerProperties.Security security = this.managementServerProperties.getSecurity();
        boolean secure = security != null && security.isEnabled();
        HealthMvcEndpoint healthMvcEndpoint = new HealthMvcEndpoint(delegate, secure);
        if (this.healthMvcEndpointProperties.getMapping() != null) {
            healthMvcEndpoint.addStatusMapping(this.healthMvcEndpointProperties.getMapping());
        }
        return healthMvcEndpoint;
    }

    @Bean
    @ConditionalOnBean(value={MetricsEndpoint.class})
    @ConditionalOnEnabledEndpoint(value="metrics")
    public MetricsMvcEndpoint metricsMvcEndpoint(MetricsEndpoint delegate) {
        return new MetricsMvcEndpoint(delegate);
    }

    @Bean
    @ConditionalOnEnabledEndpoint(value="logfile")
    @Conditional(value={LogFileCondition.class})
    public LogFileMvcEndpoint logfileMvcEndpoint() {
        return new LogFileMvcEndpoint();
    }

    @Bean
    @ConditionalOnBean(value={ShutdownEndpoint.class})
    @ConditionalOnEnabledEndpoint(value="shutdown", enabledByDefault=false)
    public ShutdownMvcEndpoint shutdownMvcEndpoint(ShutdownEndpoint delegate) {
        return new ShutdownMvcEndpoint(delegate);
    }

    private static class LogFileCondition
    extends SpringBootCondition {
        private LogFileCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment environment = context.getEnvironment();
            String config = environment.resolvePlaceholders("${logging.file:}");
            if (StringUtils.hasText((String)config)) {
                return ConditionOutcome.match((String)("Found logging.file: " + config));
            }
            config = environment.resolvePlaceholders("${logging.path:}");
            if (StringUtils.hasText((String)config)) {
                return ConditionOutcome.match((String)("Found logging.path: " + config));
            }
            config = new RelaxedPropertyResolver((PropertyResolver)environment, "endpoints.logfile.").getProperty("external-file");
            if (StringUtils.hasText((String)config)) {
                return ConditionOutcome.match((String)("Found endpoints.logfile.external-file: " + config));
            }
            return ConditionOutcome.noMatch((String)"Found no log file configuration");
        }
    }
}

