/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.actuate.endpoint.EndpointProperties;
import org.springframework.boot.actuate.endpoint.mvc.MvcEndpoint;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

public abstract class AbstractMvcEndpoint
extends WebMvcConfigurerAdapter
implements MvcEndpoint,
EnvironmentAware {
    private Environment environment;
    @NotNull
    @Pattern(regexp="/.*|^$", message="Path must start with /")
    private String path;
    private Boolean enabled;
    private Boolean sensitive;
    private final boolean sensitiveDefault;

    public AbstractMvcEndpoint(String path, boolean sensitive) {
        this.path = path;
        this.sensitiveDefault = sensitive;
    }

    public AbstractMvcEndpoint(String path, boolean sensitive, boolean enabled) {
        this.path = path;
        this.sensitiveDefault = sensitive;
        this.enabled = enabled;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected final Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isEnabled() {
        return EndpointProperties.isEnabled(this.environment, this.enabled);
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isSensitive() {
        return EndpointProperties.isSensitive(this.environment, this.sensitive, this.sensitiveDefault);
    }

    public void setSensitive(Boolean sensitive) {
        this.sensitive = sensitive;
    }

    @Override
    public Class<? extends Endpoint> getEndpointType() {
        return null;
    }
}

