/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.jolokia.http.AgentServlet;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.endpoint.mvc.AbstractMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.HypermediaDisabled;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.ServletWrappingController;
import org.springframework.web.util.UrlPathHelper;

@ConfigurationProperties(prefix="endpoints.jolokia", ignoreUnknownFields=false)
@HypermediaDisabled
public class JolokiaMvcEndpoint
extends AbstractMvcEndpoint
implements InitializingBean,
ApplicationContextAware,
ServletContextAware {
    private final ServletWrappingController controller = new ServletWrappingController();

    public JolokiaMvcEndpoint() {
        super("/jolokia", true);
        this.controller.setServletClass(AgentServlet.class);
        this.controller.setServletName("jolokia");
    }

    public void afterPropertiesSet() throws Exception {
        this.controller.afterPropertiesSet();
    }

    public void setServletContext(ServletContext servletContext) {
        this.controller.setServletContext(servletContext);
    }

    public void setInitParameters(Properties initParameters) {
        this.controller.setInitParameters(initParameters);
    }

    public final void setApplicationContext(ApplicationContext context) throws BeansException {
        this.controller.setApplicationContext(context);
    }

    @RequestMapping(value={"/**"})
    public ModelAndView handle(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.controller.handleRequest((HttpServletRequest)new PathStripper(request, this.getPath()), response);
    }

    private static class PathStripper
    extends HttpServletRequestWrapper {
        private final String path;
        private final UrlPathHelper urlPathHelper;

        PathStripper(HttpServletRequest request, String path) {
            super(request);
            this.path = path;
            this.urlPathHelper = new UrlPathHelper();
        }

        public String getPathInfo() {
            int index;
            String value = this.urlPathHelper.decodeRequestString((HttpServletRequest)this.getRequest(), super.getRequestURI());
            if (value.contains(this.path)) {
                value = value.substring(value.indexOf(this.path) + this.path.length());
            }
            if ((index = value.indexOf("?")) > 0) {
                value = value.substring(0, index);
            }
            while (value.startsWith("/")) {
                value = value.substring(1);
            }
            return value;
        }
    }
}

