/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggerConfiguration;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="endpoints.loggers")
public class LoggersEndpoint
extends AbstractEndpoint<Map<String, Object>> {
    private final LoggingSystem loggingSystem;

    public LoggersEndpoint(LoggingSystem loggingSystem) {
        super("loggers");
        Assert.notNull((Object)loggingSystem, (String)"LoggingSystem must not be null");
        this.loggingSystem = loggingSystem;
    }

    @Override
    public Map<String, Object> invoke() {
        List configurations = this.loggingSystem.getLoggerConfigurations();
        if (configurations == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("levels", this.getLevels());
        result.put("loggers", this.getLoggers(configurations));
        return result;
    }

    private NavigableSet<LogLevel> getLevels() {
        Set levels = this.loggingSystem.getSupportedLogLevels();
        return new TreeSet(levels).descendingSet();
    }

    private Map<String, LoggerLevels> getLoggers(Collection<LoggerConfiguration> configurations) {
        LinkedHashMap<String, LoggerLevels> loggers = new LinkedHashMap<String, LoggerLevels>(configurations.size());
        for (LoggerConfiguration configuration : configurations) {
            loggers.put(configuration.getName(), new LoggerLevels(configuration));
        }
        return loggers;
    }

    public LoggerLevels invoke(String name) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        LoggerConfiguration configuration = this.loggingSystem.getLoggerConfiguration(name);
        return configuration == null ? null : new LoggerLevels(configuration);
    }

    public void setLogLevel(String name, LogLevel level) {
        Assert.notNull((Object)name, (String)"Name must not be empty");
        this.loggingSystem.setLogLevel(name, level);
    }

    public static class LoggerLevels {
        private String configuredLevel;
        private String effectiveLevel;

        public LoggerLevels(LoggerConfiguration configuration) {
            this.configuredLevel = this.getName(configuration.getConfiguredLevel());
            this.effectiveLevel = this.getName(configuration.getEffectiveLevel());
        }

        private String getName(LogLevel level) {
            return level == null ? null : level.name();
        }

        public String getConfiguredLevel() {
            return this.configuredLevel;
        }

        public String getEffectiveLevel() {
            return this.effectiveLevel;
        }
    }
}

