/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import org.springframework.boot.actuate.autoconfigure.ExportMetricReader;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.actuate.metrics.buffer.BufferCounterService;
import org.springframework.boot.actuate.metrics.buffer.BufferGaugeService;
import org.springframework.boot.actuate.metrics.buffer.BufferMetricReader;
import org.springframework.boot.actuate.metrics.buffer.CounterBuffers;
import org.springframework.boot.actuate.metrics.buffer.GaugeBuffers;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MetricRepositoryAutoConfiguration {

    @Configuration
    @ConditionalOnMissingBean(value={GaugeService.class})
    static class FastMetricServicesConfiguration {
        FastMetricServicesConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public CounterBuffers counterBuffers() {
            return new CounterBuffers();
        }

        @Bean
        @ConditionalOnMissingBean
        public GaugeBuffers gaugeBuffers() {
            return new GaugeBuffers();
        }

        @Bean
        @ExportMetricReader
        @ConditionalOnMissingBean
        public BufferMetricReader actuatorMetricReader(CounterBuffers counters, GaugeBuffers gauges) {
            return new BufferMetricReader(counters, gauges);
        }

        @Bean
        @ConditionalOnMissingBean(value={CounterService.class})
        public BufferCounterService counterService(CounterBuffers writer) {
            return new BufferCounterService(writer);
        }

        @Bean
        @ConditionalOnMissingBean(value={GaugeService.class})
        public BufferGaugeService gaugeService(GaugeBuffers writer) {
            return new BufferGaugeService(writer);
        }
    }
}

