/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import org.apache.catalina.startup.Tomcat;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.CacheStatisticsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.ExportMetricReader;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.actuate.cache.CacheStatisticsProvider;
import org.springframework.boot.actuate.endpoint.CachePublicMetrics;
import org.springframework.boot.actuate.endpoint.DataSourcePublicMetrics;
import org.springframework.boot.actuate.endpoint.MetricReaderPublicMetrics;
import org.springframework.boot.actuate.endpoint.RichGaugeReaderPublicMetrics;
import org.springframework.boot.actuate.endpoint.SystemPublicMetrics;
import org.springframework.boot.actuate.endpoint.TomcatPublicMetrics;
import org.springframework.boot.actuate.metrics.integration.SpringIntegrationMetricReader;
import org.springframework.boot.actuate.metrics.reader.CompositeMetricReader;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.boot.actuate.metrics.rich.RichGaugeReader;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.integration.IntegrationAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.config.EnableIntegrationManagement;
import org.springframework.integration.support.management.IntegrationManagementConfigurer;

@Configuration
@AutoConfigureBefore(value={EndpointAutoConfiguration.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, CacheAutoConfiguration.class, MetricRepositoryAutoConfiguration.class, CacheStatisticsAutoConfiguration.class, IntegrationAutoConfiguration.class})
public class PublicMetricsAutoConfiguration {
    private final List<MetricReader> metricReaders;

    public PublicMetricsAutoConfiguration(@ExportMetricReader ObjectProvider<List<MetricReader>> metricReaders) {
        this.metricReaders = (List)metricReaders.getIfAvailable();
    }

    @Bean
    public SystemPublicMetrics systemPublicMetrics() {
        return new SystemPublicMetrics();
    }

    @Bean
    public MetricReaderPublicMetrics metricReaderPublicMetrics() {
        return new MetricReaderPublicMetrics(new CompositeMetricReader(this.metricReaders == null ? new MetricReader[]{} : this.metricReaders.toArray(new MetricReader[this.metricReaders.size()])));
    }

    @Bean
    @ConditionalOnBean(value={RichGaugeReader.class})
    public RichGaugeReaderPublicMetrics richGaugePublicMetrics(RichGaugeReader richGaugeReader) {
        return new RichGaugeReaderPublicMetrics(richGaugeReader);
    }

    @Configuration
    @ConditionalOnClass(value={EnableIntegrationManagement.class})
    static class IntegrationMetricsConfiguration {
        IntegrationMetricsConfiguration() {
        }

        @Bean(name={"integrationManagementConfigurer"})
        @ConditionalOnMissingBean(value={IntegrationManagementConfigurer.class}, name={"integrationManagementConfigurer"}, search=SearchStrategy.CURRENT)
        public IntegrationManagementConfigurer managementConfigurer() {
            IntegrationManagementConfigurer configurer = new IntegrationManagementConfigurer();
            configurer.setDefaultCountsEnabled(Boolean.valueOf(true));
            configurer.setDefaultStatsEnabled(Boolean.valueOf(true));
            return configurer;
        }

        @Bean
        @ConditionalOnMissingBean(name={"springIntegrationPublicMetrics"})
        public MetricReaderPublicMetrics springIntegrationPublicMetrics(IntegrationManagementConfigurer managementConfigurer) {
            return new MetricReaderPublicMetrics(new SpringIntegrationMetricReader(managementConfigurer));
        }
    }

    @Configuration
    @ConditionalOnClass(value={CacheManager.class})
    @ConditionalOnBean(value={CacheManager.class})
    static class CacheStatisticsConfiguration {
        CacheStatisticsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={CacheStatisticsProvider.class})
        public CachePublicMetrics cachePublicMetrics(Map<String, CacheManager> cacheManagers, Collection<CacheStatisticsProvider<?>> statisticsProviders) {
            return new CachePublicMetrics(cacheManagers, statisticsProviders);
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class, Tomcat.class})
    @ConditionalOnWebApplication
    static class TomcatMetricsConfiguration {
        TomcatMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public TomcatPublicMetrics tomcatPublicMetrics() {
            return new TomcatPublicMetrics();
        }
    }

    @Configuration
    @ConditionalOnClass(value={DataSource.class})
    @ConditionalOnBean(value={DataSource.class})
    static class DataSourceMetricsConfiguration {
        DataSourceMetricsConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnBean(value={DataSourcePoolMetadataProvider.class})
        public DataSourcePublicMetrics dataSourcePublicMetrics() {
            return new DataSourcePublicMetrics();
        }
    }
}

