/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.cache.CacheStatistics;
import org.springframework.boot.actuate.cache.CacheStatisticsProvider;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.transaction.TransactionAwareCacheDecorator;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class CachePublicMetrics
implements PublicMetrics {
    private final Map<String, CacheManager> cacheManagers;
    private final Collection<CacheStatisticsProvider<?>> statisticsProviders;

    public CachePublicMetrics(Map<String, CacheManager> cacheManagers, Collection<CacheStatisticsProvider<?>> statisticsProviders) {
        this.cacheManagers = cacheManagers;
        this.statisticsProviders = statisticsProviders;
    }

    @Override
    public Collection<Metric<?>> metrics() {
        HashSet metrics = new HashSet();
        for (Map.Entry entry : this.getCacheManagerBeans().entrySet()) {
            this.addMetrics(metrics, (String)entry.getKey(), (List)entry.getValue());
        }
        return metrics;
    }

    private MultiValueMap<String, CacheManagerBean> getCacheManagerBeans() {
        LinkedMultiValueMap cacheManagerNamesByCacheName = new LinkedMultiValueMap();
        for (Map.Entry<String, CacheManager> entry : this.cacheManagers.entrySet()) {
            for (String cacheName : entry.getValue().getCacheNames()) {
                cacheManagerNamesByCacheName.add((Object)cacheName, (Object)new CacheManagerBean(entry.getKey(), entry.getValue()));
            }
        }
        return cacheManagerNamesByCacheName;
    }

    private void addMetrics(Collection<Metric<?>> metrics, String cacheName, List<CacheManagerBean> cacheManagerBeans) {
        for (CacheManagerBean cacheManagerBean : cacheManagerBeans) {
            CacheManager cacheManager = cacheManagerBean.getCacheManager();
            Cache cache = this.unwrapIfNecessary(cacheManager.getCache(cacheName));
            CacheStatistics statistics = this.getCacheStatistics(cache, cacheManager);
            if (statistics == null) continue;
            String prefix = cacheName;
            if (cacheManagerBeans.size() > 1) {
                prefix = cacheManagerBean.getBeanName() + "_" + prefix;
            }
            prefix = "cache." + prefix + (prefix.endsWith(".") ? "" : ".");
            metrics.addAll(statistics.toMetrics(prefix));
        }
    }

    private Cache unwrapIfNecessary(Cache cache) {
        if (ClassUtils.isPresent((String)"org.springframework.cache.transaction.TransactionAwareCacheDecorator", (ClassLoader)this.getClass().getClassLoader())) {
            return TransactionAwareCacheDecoratorHandler.unwrapIfNecessary(cache);
        }
        return cache;
    }

    private CacheStatistics getCacheStatistics(Cache cache, CacheManager cacheManager) {
        if (this.statisticsProviders != null) {
            for (CacheStatisticsProvider<?> provider : this.statisticsProviders) {
                CacheStatistics statistics;
                Class cacheType = ResolvableType.forClass(CacheStatisticsProvider.class, provider.getClass()).resolveGeneric(new int[0]);
                if (!cacheType.isInstance(cache) || (statistics = provider.getCacheStatistics(cacheManager, cache)) == null) continue;
                return statistics;
            }
        }
        return null;
    }

    private static class TransactionAwareCacheDecoratorHandler {
        private TransactionAwareCacheDecoratorHandler() {
        }

        private static Cache unwrapIfNecessary(Cache cache) {
            try {
                if (cache instanceof TransactionAwareCacheDecorator) {
                    return ((TransactionAwareCacheDecorator)cache).getTargetCache();
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return cache;
        }
    }

    private static class CacheManagerBean {
        private final String beanName;
        private final CacheManager cacheManager;

        CacheManagerBean(String beanName, CacheManager cacheManager) {
            this.beanName = beanName;
            this.cacheManager = cacheManager;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public CacheManager getCacheManager() {
            return this.cacheManager;
        }
    }
}

