/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.session.ManagerBase;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.web.embedded.tomcat.TomcatWebServer;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class TomcatPublicMetrics
implements PublicMetrics,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Override
    public Collection<Metric<?>> metrics() {
        Manager manager;
        if (this.applicationContext instanceof ServletWebServerApplicationContext && (manager = this.getManager((ServletWebServerApplicationContext)this.applicationContext)) != null) {
            return this.metrics(manager);
        }
        return Collections.emptySet();
    }

    private Manager getManager(ServletWebServerApplicationContext applicationContext) {
        WebServer webServer = applicationContext.getWebServer();
        if (webServer instanceof TomcatWebServer) {
            return this.getManager((TomcatWebServer)webServer);
        }
        return null;
    }

    private Manager getManager(TomcatWebServer webServer) {
        for (Container container : webServer.getTomcat().getHost().findChildren()) {
            if (!(container instanceof Context)) continue;
            return ((Context)container).getManager();
        }
        return null;
    }

    private Collection<Metric<?>> metrics(Manager manager) {
        ArrayList metrics = new ArrayList(2);
        if (manager instanceof ManagerBase) {
            this.addMetric(metrics, "httpsessions.max", ((ManagerBase)manager).getMaxActiveSessions());
        }
        this.addMetric(metrics, "httpsessions.active", manager.getActiveSessions());
        return metrics;
    }

    private void addMetric(List<Metric<?>> metrics, String name, Integer value) {
        metrics.add(new Metric<Integer>(name, value));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

