/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.ActuatorGetMapping;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ConfigurationProperties(prefix="endpoints.auditevents")
public class AuditEventsMvcEndpoint
extends AbstractNamedMvcEndpoint {
    private final AuditEventRepository auditEventRepository;

    public AuditEventsMvcEndpoint(AuditEventRepository auditEventRepository) {
        super("auditevents", "/auditevents", true);
        Assert.notNull((Object)auditEventRepository, (String)"AuditEventRepository must not be null");
        this.auditEventRepository = auditEventRepository;
    }

    @ActuatorGetMapping
    @ResponseBody
    public ResponseEntity<?> findByPrincipalAndAfterAndType(@RequestParam(required=false) String principal, @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd'T'HH:mm:ssZ") Date after, @RequestParam(required=false) String type) {
        if (!this.isEnabled()) {
            return DISABLED_RESPONSE;
        }
        LinkedHashMap<String, List<AuditEvent>> result = new LinkedHashMap<String, List<AuditEvent>>();
        result.put("events", this.auditEventRepository.find(principal, after, type));
        return ResponseEntity.ok(result);
    }
}

