/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.actuate.endpoint.mvc.HalJsonMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.ManagementServletContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.TransformedResource;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class HalBrowserMvcEndpoint
extends HalJsonMvcEndpoint
implements ResourceLoaderAware {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static HalBrowserLocation[] HAL_BROWSER_RESOURCE_LOCATIONS = new HalBrowserLocation[]{new HalBrowserLocation("classpath:/META-INF/spring-data-rest/hal-browser/", "index.html"), new HalBrowserLocation("classpath:/META-INF/resources/webjars/hal-browser/3325375/", "browser.html")};
    private HalBrowserLocation location;

    public HalBrowserMvcEndpoint(ManagementServletContext managementServletContext) {
        super(managementServletContext);
    }

    @RequestMapping(produces={"text/html"})
    public String browse(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromRequest((HttpServletRequest)request);
        String uriString = builder.build().toUriString();
        return "redirect:" + uriString + (uriString.endsWith("/") ? "" : "/") + this.location.getHtmlFile();
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.location = HalBrowserMvcEndpoint.getHalBrowserLocation(resourceLoader);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        if (this.location != null) {
            String start = this.getManagementServletContext().getContextPath() + this.getPath();
            registry.addResourceHandler(new String[]{start + "/", start + "/**"}).addResourceLocations(new String[]{this.location.getResourceLocation()}).setCachePeriod(Integer.valueOf(0)).resourceChain(true).addTransformer((ResourceTransformer)new InitialUrlTransformer());
        }
    }

    public static HalBrowserLocation getHalBrowserLocation(ResourceLoader resourceLoader) {
        for (HalBrowserLocation candidate : HAL_BROWSER_RESOURCE_LOCATIONS) {
            try {
                Resource resource = resourceLoader.getResource(candidate.toString());
                if (resource == null || !resource.exists()) continue;
                return candidate;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private class InitialUrlTransformer
    implements ResourceTransformer {
        private InitialUrlTransformer() {
        }

        public Resource transform(HttpServletRequest request, Resource resource, ResourceTransformerChain transformerChain) throws IOException {
            if ((resource = transformerChain.transform(request, resource)).getFilename().equalsIgnoreCase(HalBrowserMvcEndpoint.this.location.getHtmlFile())) {
                return this.replaceInitialLink(request, resource);
            }
            return resource;
        }

        private Resource replaceInitialLink(HttpServletRequest request, Resource resource) throws IOException {
            byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream());
            String content = new String(bytes, DEFAULT_CHARSET);
            ArrayList pathSegments = new ArrayList(ServletUriComponentsBuilder.fromRequest((HttpServletRequest)request).build().getPathSegments());
            pathSegments.remove(pathSegments.size() - 1);
            String initial = "/" + StringUtils.collectionToDelimitedString(pathSegments, (String)"/");
            content = content.replace("entryPoint: '/'", "entryPoint: '" + initial + "'");
            return new TransformedResource(resource, content.getBytes(DEFAULT_CHARSET));
        }
    }

    public static class HalBrowserLocation {
        private final String resourceLocation;
        private final String htmlFile;

        public HalBrowserLocation(String resourceLocation, String html) {
            this.resourceLocation = resourceLocation;
            this.htmlFile = html;
        }

        public String getResourceLocation() {
            return this.resourceLocation;
        }

        public String getHtmlFile() {
            return this.htmlFile;
        }

        public String toString() {
            return this.resourceLocation + this.htmlFile;
        }
    }
}

