/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.mvc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.HypermediaDisabled;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@ConfigurationProperties(prefix="endpoints.heapdump")
@HypermediaDisabled
public class HeapdumpMvcEndpoint
extends AbstractNamedMvcEndpoint {
    private final long timeout;
    private final Lock lock = new ReentrantLock();
    private HeapDumper heapDumper;

    public HeapdumpMvcEndpoint() {
        this(TimeUnit.SECONDS.toMillis(10L));
    }

    protected HeapdumpMvcEndpoint(long timeout) {
        super("heapdump", "/heapdump", true);
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(method={RequestMethod.GET}, produces={"application/octet-stream"})
    public void invoke(@RequestParam(defaultValue="true") boolean live, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this.isEnabled()) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return;
        }
        try {
            if (this.lock.tryLock(this.timeout, TimeUnit.MILLISECONDS)) {
                try {
                    this.dumpHeap(live, request, response);
                    return;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        response.setStatus(HttpStatus.TOO_MANY_REQUESTS.value());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpHeap(boolean live, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, InterruptedException {
        if (this.heapDumper == null) {
            this.heapDumper = this.createHeapDumper();
        }
        File file = this.createTempFile(live);
        try {
            this.heapDumper.dumpHeap(file, live);
            this.handle(file, request, response);
        }
        finally {
            file.delete();
        }
    }

    private File createTempFile(boolean live) throws IOException {
        String date = new SimpleDateFormat("yyyy-MM-dd-HH-mm").format(new Date());
        File file = File.createTempFile("heapdump" + date + (live ? "-live" : ""), ".hprof");
        file.delete();
        return file;
    }

    protected HeapDumper createHeapDumper() throws HeapDumperUnavailableException {
        return new HotSpotDiagnosticMXBeanHeapDumper();
    }

    protected void handle(File heapDumpFile, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + heapDumpFile.getName() + ".gz" + "\"");
        try (FileInputStream in = new FileInputStream(heapDumpFile);
             GZIPOutputStream out = new GZIPOutputStream((OutputStream)response.getOutputStream());){
            StreamUtils.copy((InputStream)in, (OutputStream)out);
            out.finish();
        }
        catch (FileNotFoundException | NullPointerException exception) {
            // empty catch block
        }
    }

    @ResponseStatus(value=HttpStatus.SERVICE_UNAVAILABLE)
    protected static class HeapDumperUnavailableException
    extends RuntimeException {
        public HeapDumperUnavailableException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    protected static class HotSpotDiagnosticMXBeanHeapDumper
    implements HeapDumper {
        private Object diagnosticMXBean;
        private Method dumpHeapMethod;

        protected HotSpotDiagnosticMXBeanHeapDumper() {
            try {
                Class diagnosticMXBeanClass = ClassUtils.resolveClassName((String)"com.sun.management.HotSpotDiagnosticMXBean", null);
                this.diagnosticMXBean = ManagementFactory.getPlatformMXBean(diagnosticMXBeanClass);
                this.dumpHeapMethod = ReflectionUtils.findMethod((Class)diagnosticMXBeanClass, (String)"dumpHeap", (Class[])new Class[]{String.class, Boolean.TYPE});
            }
            catch (Throwable ex) {
                throw new HeapDumperUnavailableException("Unable to locate HotSpotDiagnosticMXBean", ex);
            }
        }

        @Override
        public void dumpHeap(File file, boolean live) {
            ReflectionUtils.invokeMethod((Method)this.dumpHeapMethod, (Object)this.diagnosticMXBean, (Object[])new Object[]{file.getAbsolutePath(), live});
        }
    }

    @FunctionalInterface
    protected static interface HeapDumper {
        public void dumpHeap(File var1, boolean var2) throws IOException, InterruptedException;
    }
}

