/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.health;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class JmsHealthIndicator
extends AbstractHealthIndicator {
    private final ConnectionFactory connectionFactory;

    public JmsHealthIndicator(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        try (Connection connection = this.connectionFactory.createConnection();){
            connection.start();
            builder.up().withDetail("provider", connection.getMetaData().getJMSProviderName());
        }
    }
}

