/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.buffer;

import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.buffer.CounterBuffers;

public class BufferCounterService
implements CounterService {
    private final ConcurrentHashMap<String, String> names = new ConcurrentHashMap();
    private final CounterBuffers buffers;

    public BufferCounterService(CounterBuffers buffers) {
        this.buffers = buffers;
    }

    @Override
    public void increment(String metricName) {
        this.buffers.increment(this.wrap(metricName), 1L);
    }

    @Override
    public void decrement(String metricName) {
        this.buffers.increment(this.wrap(metricName), -1L);
    }

    @Override
    public void reset(String metricName) {
        this.buffers.reset(this.wrap(metricName));
    }

    private String wrap(String metricName) {
        String cached = this.names.get(metricName);
        if (cached != null) {
            return cached;
        }
        if (metricName.startsWith("counter") || metricName.startsWith("meter")) {
            return metricName;
        }
        String name = "counter." + metricName;
        this.names.put(metricName, name);
        return name;
    }
}

