/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.boot.actuate.endpoint.OperationParameterMapper;
import org.springframework.boot.actuate.endpoint.ParametersMissingException;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public class ReflectiveOperationInvoker
implements OperationInvoker {
    private final OperationParameterMapper parameterMapper;
    private final Object target;
    private final Method method;

    public ReflectiveOperationInvoker(OperationParameterMapper parameterMapper, Object target, Method method) {
        this.parameterMapper = parameterMapper;
        this.target = target;
        ReflectionUtils.makeAccessible((Method)method);
        this.method = method;
    }

    @Override
    public Object invoke(Map<String, Object> arguments) {
        this.validateRequiredParameters(arguments);
        return ReflectionUtils.invokeMethod((Method)this.method, (Object)this.target, (Object[])this.resolveArguments(arguments));
    }

    private void validateRequiredParameters(Map<String, Object> arguments) {
        Set<String> missingParameters = Stream.of(this.method.getParameters()).filter(p -> this.isMissing((Parameter)p, arguments)).map(Parameter::getName).collect(Collectors.toSet());
        if (!missingParameters.isEmpty()) {
            throw new ParametersMissingException(missingParameters);
        }
    }

    private boolean isMissing(Parameter parameter, Map<String, Object> arguments) {
        Object resolved = arguments.get(parameter.getName());
        return resolved == null && !this.isExplicitNullable(parameter);
    }

    private boolean isExplicitNullable(Parameter parameter) {
        return ((Nullable[])parameter.getAnnotationsByType(Nullable.class)).length != 0;
    }

    private Object[] resolveArguments(Map<String, Object> arguments) {
        return Stream.of(this.method.getParameters()).map(parameter -> this.resolveArgument((Parameter)parameter, arguments)).collect(Collectors.collectingAndThen(Collectors.toList(), list -> list.toArray(new Object[list.size()])));
    }

    private Object resolveArgument(Parameter parameter, Map<String, Object> arguments) {
        Object resolved = arguments.get(parameter.getName());
        return this.parameterMapper.mapParameter(resolved, parameter.getType());
    }
}

