/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.cache;

import java.util.Map;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.util.Assert;

public class CachingOperationInvoker
implements OperationInvoker {
    private final OperationInvoker target;
    private final long timeToLive;
    private volatile CachedResponse cachedResponse;

    public CachingOperationInvoker(OperationInvoker target, long timeToLive) {
        Assert.state((timeToLive > 0L ? 1 : 0) != 0, (String)"TimeToLive must be strictly positive");
        this.target = target;
        this.timeToLive = timeToLive;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public Object invoke(Map<String, Object> arguments) {
        long accessTime = System.currentTimeMillis();
        CachedResponse cached = this.cachedResponse;
        if (cached == null || cached.isStale(accessTime, this.timeToLive)) {
            Object response = this.target.invoke(arguments);
            this.cachedResponse = new CachedResponse(response, accessTime);
            return response;
        }
        return cached.getResponse();
    }

    static class CachedResponse {
        private final Object response;
        private final long creationTime;

        CachedResponse(Object response, long creationTime) {
            this.response = response;
            this.creationTime = creationTime;
        }

        public boolean isStale(long accessTime, long timeToLive) {
            return accessTime - this.creationTime >= timeToLive;
        }

        public Object getResponse() {
            return this.response;
        }
    }
}

