/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.jmx;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;
import org.springframework.boot.actuate.endpoint.ParameterMappingException;
import org.springframework.boot.actuate.endpoint.ParametersMissingException;
import org.springframework.boot.actuate.endpoint.jmx.EndpointMBeanInfo;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointOperation;
import org.springframework.boot.actuate.endpoint.jmx.JmxEndpointOperationParameterInfo;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Mono;

public class EndpointMBean
implements DynamicMBean {
    private static final boolean REACTOR_PRESENT = ClassUtils.isPresent((String)"reactor.core.publisher.Mono", (ClassLoader)EndpointMBean.class.getClassLoader());
    private final Function<Object, Object> operationResponseConverter;
    private final EndpointMBeanInfo endpointInfo;

    EndpointMBean(Function<Object, Object> operationResponseConverter, EndpointMBeanInfo endpointInfo) {
        this.operationResponseConverter = operationResponseConverter;
        this.endpointInfo = endpointInfo;
    }

    public String getEndpointId() {
        return this.endpointInfo.getEndpointId();
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.endpointInfo.getMbeanInfo();
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        JmxEndpointOperation operation = this.endpointInfo.getOperations().get(actionName);
        if (operation != null) {
            Map<String, Object> arguments = this.getArguments(params, operation.getParameters());
            try {
                Object result = operation.getInvoker().invoke(arguments);
                if (REACTOR_PRESENT) {
                    result = ReactiveHandler.handle(result);
                }
                return this.operationResponseConverter.apply(result);
            }
            catch (ParameterMappingException | ParametersMissingException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
        throw new ReflectionException(new IllegalArgumentException(String.format("Endpoint with id '%s' has no operation named %s", this.endpointInfo.getEndpointId(), actionName)));
    }

    private Map<String, Object> getArguments(Object[] params, List<JmxEndpointOperationParameterInfo> parameters) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        for (int i = 0; i < params.length; ++i) {
            arguments.put(parameters.get(i).getName(), params[i]);
        }
        return arguments;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException();
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new AttributeNotFoundException();
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        return new AttributeList();
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }

    private static class ReactiveHandler {
        private ReactiveHandler() {
        }

        public static Object handle(Object result) {
            if (result instanceof Mono) {
                return ((Mono)result).block();
            }
            return result;
        }
    }
}

