/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.springframework.boot.actuate.endpoint.EndpointExposure;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.boot.actuate.endpoint.OperationParameterMapper;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.ReflectiveOperationInvoker;
import org.springframework.boot.actuate.endpoint.annotation.AnnotationEndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.actuate.endpoint.cache.CachingConfigurationFactory;
import org.springframework.boot.actuate.endpoint.cache.CachingOperationInvoker;
import org.springframework.boot.actuate.endpoint.web.OperationRequestPredicate;
import org.springframework.boot.actuate.endpoint.web.WebEndpointHttpMethod;
import org.springframework.boot.actuate.endpoint.web.WebEndpointOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpointExtension;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;

public class WebAnnotationEndpointDiscoverer
extends AnnotationEndpointDiscoverer<WebEndpointOperation, OperationRequestPredicate> {
    public WebAnnotationEndpointDiscoverer(ApplicationContext applicationContext, OperationParameterMapper operationParameterMapper, CachingConfigurationFactory cachingConfigurationFactory, Collection<String> consumedMediaTypes, Collection<String> producedMediaTypes) {
        super(applicationContext, new WebEndpointOperationFactory(operationParameterMapper, consumedMediaTypes, producedMediaTypes), WebEndpointOperation::getRequestPredicate, cachingConfigurationFactory);
    }

    @Override
    public Collection<EndpointInfo<WebEndpointOperation>> discoverEndpoints() {
        Collection<AnnotationEndpointDiscoverer.EndpointInfoDescriptor<WebEndpointOperation, OperationRequestPredicate>> endpoints = this.discoverEndpoints(WebEndpointExtension.class, EndpointExposure.WEB);
        this.verifyThatOperationsHaveDistinctPredicates(endpoints);
        return endpoints.stream().map(AnnotationEndpointDiscoverer.EndpointInfoDescriptor::getEndpointInfo).collect(Collectors.toList());
    }

    private void verifyThatOperationsHaveDistinctPredicates(Collection<AnnotationEndpointDiscoverer.EndpointInfoDescriptor<WebEndpointOperation, OperationRequestPredicate>> endpointDescriptors) {
        ArrayList clashes = new ArrayList();
        endpointDescriptors.forEach(descriptor -> clashes.addAll(descriptor.findDuplicateOperations().values()));
        if (!clashes.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append(String.format("Found multiple web operations with matching request predicates:%n", new Object[0]));
            clashes.forEach(clash -> {
                message.append("    ").append(((WebEndpointOperation)clash.get(0)).getRequestPredicate()).append(String.format(":%n", new Object[0]));
                clash.forEach(operation -> message.append("        ").append(String.format("%s%n", operation)));
            });
            throw new IllegalStateException(message.toString());
        }
    }

    private static final class WebEndpointOperationFactory
    implements AnnotationEndpointDiscoverer.EndpointOperationFactory<WebEndpointOperation> {
        private static final boolean REACTIVE_STREAMS_PRESENT = ClassUtils.isPresent((String)"org.reactivestreams.Publisher", (ClassLoader)WebEndpointOperationFactory.class.getClassLoader());
        private final OperationParameterMapper parameterMapper;
        private final Collection<String> consumedMediaTypes;
        private final Collection<String> producedMediaTypes;

        private WebEndpointOperationFactory(OperationParameterMapper parameterMapper, Collection<String> consumedMediaTypes, Collection<String> producedMediaTypes) {
            this.parameterMapper = parameterMapper;
            this.consumedMediaTypes = consumedMediaTypes;
            this.producedMediaTypes = producedMediaTypes;
        }

        @Override
        public WebEndpointOperation createOperation(String endpointId, AnnotationAttributes operationAttributes, Object target, Method method, OperationType type, long timeToLive) {
            WebEndpointHttpMethod httpMethod = this.determineHttpMethod(type);
            OperationRequestPredicate requestPredicate = new OperationRequestPredicate(this.determinePath(endpointId, method), httpMethod, this.determineConsumedMediaTypes(httpMethod, method), this.determineProducedMediaTypes(operationAttributes.getStringArray("produces"), method));
            OperationInvoker invoker = new ReflectiveOperationInvoker(this.parameterMapper, target, method);
            if (timeToLive > 0L) {
                invoker = new CachingOperationInvoker(invoker, timeToLive);
            }
            return new WebEndpointOperation(type, invoker, this.determineBlocking(method), requestPredicate, this.determineId(endpointId, method));
        }

        private String determinePath(String endpointId, Method operationMethod) {
            StringBuilder path = new StringBuilder(endpointId);
            Stream.of(operationMethod.getParameters()).filter(parameter -> parameter.getAnnotation(Selector.class) != null).map(parameter -> "/{" + parameter.getName() + "}").forEach(path::append);
            return path.toString();
        }

        private String determineId(String endpointId, Method operationMethod) {
            StringBuilder path = new StringBuilder(endpointId);
            Stream.of(operationMethod.getParameters()).filter(parameter -> parameter.getAnnotation(Selector.class) != null).map(parameter -> "-" + parameter.getName()).forEach(path::append);
            return path.toString();
        }

        private Collection<String> determineConsumedMediaTypes(WebEndpointHttpMethod httpMethod, Method method) {
            if (WebEndpointHttpMethod.POST == httpMethod && this.consumesRequestBody(method)) {
                return this.consumedMediaTypes;
            }
            return Collections.emptyList();
        }

        private Collection<String> determineProducedMediaTypes(String[] produces, Method method) {
            if (produces.length > 0) {
                return Arrays.asList(produces);
            }
            if (Void.class.equals(method.getReturnType()) || Void.TYPE.equals(method.getReturnType())) {
                return Collections.emptyList();
            }
            if (this.producesResourceResponseBody(method)) {
                return Collections.singletonList("application/octet-stream");
            }
            return this.producedMediaTypes;
        }

        private boolean producesResourceResponseBody(Method method) {
            if (Resource.class.equals(method.getReturnType())) {
                return true;
            }
            if (WebEndpointResponse.class.isAssignableFrom(method.getReturnType())) {
                ResolvableType returnType = ResolvableType.forMethodReturnType((Method)method);
                if (ResolvableType.forClass(Resource.class).isAssignableFrom(returnType.getGeneric(new int[]{0}))) {
                    return true;
                }
            }
            return false;
        }

        private boolean consumesRequestBody(Method method) {
            return Stream.of(method.getParameters()).anyMatch(parameter -> parameter.getAnnotation(Selector.class) == null);
        }

        private WebEndpointHttpMethod determineHttpMethod(OperationType operationType) {
            if (operationType == OperationType.WRITE) {
                return WebEndpointHttpMethod.POST;
            }
            if (operationType == OperationType.DELETE) {
                return WebEndpointHttpMethod.DELETE;
            }
            return WebEndpointHttpMethod.GET;
        }

        private boolean determineBlocking(Method method) {
            return !REACTIVE_STREAMS_PRESENT || !Publisher.class.isAssignableFrom(method.getReturnType());
        }
    }
}

