/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.reactive;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.boot.actuate.endpoint.OperationType;
import org.springframework.boot.actuate.endpoint.ParameterMappingException;
import org.springframework.boot.actuate.endpoint.ParametersMissingException;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.OperationRequestPredicate;
import org.springframework.boot.actuate.endpoint.web.WebEndpointOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.endpoint.web.EndpointMapping;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.result.condition.ConsumesRequestCondition;
import org.springframework.web.reactive.result.condition.PatternsRequestCondition;
import org.springframework.web.reactive.result.condition.ProducesRequestCondition;
import org.springframework.web.reactive.result.condition.RequestMethodsRequestCondition;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import org.springframework.web.reactive.result.method.RequestMappingInfoHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.scheduler.Schedulers;

public class WebFluxEndpointHandlerMapping
extends RequestMappingInfoHandlerMapping
implements InitializingBean {
    private static final PathPatternParser pathPatternParser = new PathPatternParser();
    private final Method handleRead = ReflectionUtils.findMethod(ReadOperationHandler.class, (String)"handle", (Class[])new Class[]{ServerWebExchange.class});
    private final Method handleWrite = ReflectionUtils.findMethod(WriteOperationHandler.class, (String)"handle", (Class[])new Class[]{ServerWebExchange.class, Map.class});
    private final Method links = ReflectionUtils.findMethod(((Object)((Object)this)).getClass(), (String)"links", (Class[])new Class[]{ServerHttpRequest.class});
    private final EndpointLinksResolver endpointLinksResolver = new EndpointLinksResolver();
    private final EndpointMapping endpointMapping;
    private final Collection<EndpointInfo<WebEndpointOperation>> webEndpoints;
    private final CorsConfiguration corsConfiguration;

    public WebFluxEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<EndpointInfo<WebEndpointOperation>> collection) {
        this(endpointMapping, collection, null);
    }

    public WebFluxEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<EndpointInfo<WebEndpointOperation>> webEndpoints, CorsConfiguration corsConfiguration) {
        this.endpointMapping = endpointMapping;
        this.webEndpoints = webEndpoints;
        this.corsConfiguration = corsConfiguration;
        this.setOrder(-100);
    }

    protected void initHandlerMethods() {
        this.webEndpoints.stream().flatMap(webEndpoint -> webEndpoint.getOperations().stream()).forEach(this::registerMappingForOperation);
        if (StringUtils.hasText((String)this.endpointMapping.getPath())) {
            this.registerLinksMapping();
        }
    }

    private void registerLinksMapping() {
        this.registerMapping(new RequestMappingInfo(new PatternsRequestCondition(new PathPattern[]{pathPatternParser.parse(this.endpointMapping.getPath())}), new RequestMethodsRequestCondition(new RequestMethod[]{RequestMethod.GET}), null, null, null, null, null), (Object)this, this.links);
    }

    protected CorsConfiguration initCorsConfiguration(Object handler, Method method, RequestMappingInfo mapping) {
        return this.corsConfiguration;
    }

    private void registerMappingForOperation(WebEndpointOperation operation) {
        OperationType operationType = operation.getType();
        OperationInvoker operationInvoker = operation.getInvoker();
        if (operation.isBlocking()) {
            operationInvoker = new ElasticSchedulerOperationInvoker(operationInvoker);
        }
        this.registerMapping(this.createRequestMappingInfo(operation), operationType == OperationType.WRITE ? new WriteOperationHandler(operationInvoker) : new ReadOperationHandler(operationInvoker), operationType == OperationType.WRITE ? this.handleWrite : this.handleRead);
    }

    private RequestMappingInfo createRequestMappingInfo(WebEndpointOperation operationInfo) {
        OperationRequestPredicate requestPredicate = operationInfo.getRequestPredicate();
        PatternsRequestCondition patterns = new PatternsRequestCondition(new PathPattern[]{pathPatternParser.parse(this.endpointMapping.createSubPath(requestPredicate.getPath()))});
        RequestMethodsRequestCondition methods = new RequestMethodsRequestCondition(new RequestMethod[]{RequestMethod.valueOf((String)requestPredicate.getHttpMethod().name())});
        ConsumesRequestCondition consumes = new ConsumesRequestCondition(this.toStringArray(requestPredicate.getConsumes()));
        ProducesRequestCondition produces = new ProducesRequestCondition(this.toStringArray(requestPredicate.getProduces()));
        return new RequestMappingInfo(null, patterns, methods, null, null, consumes, produces, null);
    }

    private String[] toStringArray(Collection<String> collection) {
        return collection.toArray(new String[collection.size()]);
    }

    protected boolean isHandler(Class<?> beanType) {
        return false;
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        return null;
    }

    @ResponseBody
    private Map<String, Map<String, Link>> links(ServerHttpRequest request) {
        return Collections.singletonMap("_links", this.endpointLinksResolver.resolveLinks(this.webEndpoints, UriComponentsBuilder.fromUri((URI)request.getURI()).replaceQuery(null).toUriString()));
    }

    private static final class ElasticSchedulerOperationInvoker
    implements OperationInvoker {
        private final OperationInvoker delegate;

        private ElasticSchedulerOperationInvoker(OperationInvoker delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Map<String, Object> arguments) {
            return Mono.create(sink -> Schedulers.elastic().schedule(() -> this.invoke(arguments, (MonoSink<Object>)sink)));
        }

        private void invoke(Map<String, Object> arguments, MonoSink<Object> sink) {
            try {
                Object result = this.delegate.invoke(arguments);
                sink.success(result);
            }
            catch (Exception ex) {
                sink.error((Throwable)ex);
            }
        }
    }

    final class ReadOperationHandler
    extends AbstractOperationHandler {
        ReadOperationHandler(OperationInvoker operationInvoker) {
            super(operationInvoker);
        }

        @ResponseBody
        public Publisher<ResponseEntity<Object>> handle(ServerWebExchange exchange) {
            return this.doHandle(exchange, null);
        }
    }

    final class WriteOperationHandler
    extends AbstractOperationHandler {
        WriteOperationHandler(OperationInvoker operationInvoker) {
            super(operationInvoker);
        }

        @ResponseBody
        public Publisher<ResponseEntity<Object>> handle(ServerWebExchange exchange, @RequestBody(required=false) Map<String, String> body) {
            return this.doHandle(exchange, body);
        }
    }

    abstract class AbstractOperationHandler {
        private final OperationInvoker operationInvoker;

        AbstractOperationHandler(OperationInvoker operationInvoker) {
            this.operationInvoker = operationInvoker;
        }

        Publisher<ResponseEntity<Object>> doHandle(ServerWebExchange exchange, Map<String, String> body) {
            HashMap<String, Object> arguments = new HashMap<String, Object>((Map)exchange.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE));
            if (body != null) {
                arguments.putAll(body);
            }
            exchange.getRequest().getQueryParams().forEach((name, values) -> arguments.put((String)name, values.size() == 1 ? values.get(0) : values));
            return this.handleResult((Publisher)this.operationInvoker.invoke(arguments), exchange.getRequest().getMethod());
        }

        private Publisher<ResponseEntity<Object>> handleResult(Publisher<?> result, HttpMethod httpMethod) {
            return Mono.from(result).map(this::toResponseEntity).onErrorReturn(ParametersMissingException.class, (Object)new ResponseEntity(HttpStatus.BAD_REQUEST)).onErrorReturn(ParameterMappingException.class, (Object)new ResponseEntity(HttpStatus.BAD_REQUEST)).defaultIfEmpty((Object)new ResponseEntity(httpMethod == HttpMethod.GET ? HttpStatus.NOT_FOUND : HttpStatus.NO_CONTENT));
        }

        private ResponseEntity<Object> toResponseEntity(Object response) {
            if (!(response instanceof WebEndpointResponse)) {
                return new ResponseEntity(response, HttpStatus.OK);
            }
            WebEndpointResponse webEndpointResponse = (WebEndpointResponse)response;
            return new ResponseEntity(webEndpointResponse.getBody(), HttpStatus.valueOf((int)webEndpointResponse.getStatus()));
        }
    }
}

