/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web.servlet;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.web.OperationRequestPredicate;
import org.springframework.boot.actuate.endpoint.web.WebEndpointOperation;
import org.springframework.boot.endpoint.web.EndpointMapping;
import org.springframework.util.StringUtils;
import org.springframework.web.accept.PathExtensionContentNegotiationStrategy;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.mvc.condition.ConsumesRequestCondition;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

public abstract class AbstractWebMvcEndpointHandlerMapping
extends RequestMappingInfoHandlerMapping
implements InitializingBean {
    private final EndpointMapping endpointMapping;
    private final Collection<EndpointInfo<WebEndpointOperation>> webEndpoints;
    private final CorsConfiguration corsConfiguration;

    public AbstractWebMvcEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<EndpointInfo<WebEndpointOperation>> collection) {
        this(endpointMapping, collection, null);
    }

    public AbstractWebMvcEndpointHandlerMapping(EndpointMapping endpointMapping, Collection<EndpointInfo<WebEndpointOperation>> webEndpoints, CorsConfiguration corsConfiguration) {
        this.endpointMapping = endpointMapping;
        this.webEndpoints = webEndpoints;
        this.corsConfiguration = corsConfiguration;
        this.setOrder(-100);
    }

    public Collection<EndpointInfo<WebEndpointOperation>> getEndpoints() {
        return this.webEndpoints;
    }

    public EndpointMapping getEndpointMapping() {
        return this.endpointMapping;
    }

    protected void initHandlerMethods() {
        this.webEndpoints.stream().flatMap(webEndpoint -> webEndpoint.getOperations().stream()).forEach(this::registerMappingForOperation);
        if (StringUtils.hasText((String)this.endpointMapping.getPath())) {
            this.registerLinksRequestMapping();
        }
    }

    private void registerLinksRequestMapping() {
        PatternsRequestCondition patterns = this.patternsRequestConditionForPattern("");
        RequestMethodsRequestCondition methods = new RequestMethodsRequestCondition(new RequestMethod[]{RequestMethod.GET});
        RequestMappingInfo mapping = new RequestMappingInfo(patterns, methods, null, null, null, null, null);
        this.registerMapping(mapping, (Object)this, this.getLinks());
    }

    protected CorsConfiguration initCorsConfiguration(Object handler, Method method, RequestMappingInfo mapping) {
        return this.corsConfiguration;
    }

    protected abstract Method getLinks();

    protected abstract void registerMappingForOperation(WebEndpointOperation var1);

    protected RequestMappingInfo createRequestMappingInfo(WebEndpointOperation operationInfo) {
        OperationRequestPredicate requestPredicate = operationInfo.getRequestPredicate();
        PatternsRequestCondition patterns = this.patternsRequestConditionForPattern(requestPredicate.getPath());
        RequestMethodsRequestCondition methods = new RequestMethodsRequestCondition(new RequestMethod[]{RequestMethod.valueOf((String)requestPredicate.getHttpMethod().name())});
        ConsumesRequestCondition consumes = new ConsumesRequestCondition(this.toStringArray(requestPredicate.getConsumes()));
        ProducesRequestCondition produces = new ProducesRequestCondition(this.toStringArray(requestPredicate.getProduces()));
        return new RequestMappingInfo(null, patterns, methods, null, null, consumes, produces, null);
    }

    private PatternsRequestCondition patternsRequestConditionForPattern(String path) {
        String[] patterns = new String[]{this.endpointMapping.createSubPath(path)};
        return new PatternsRequestCondition(patterns, null, null, false, false);
    }

    private String[] toStringArray(Collection<String> collection) {
        return collection.toArray(new String[collection.size()]);
    }

    protected boolean isHandler(Class<?> beanType) {
        return false;
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        return null;
    }

    protected void extendInterceptors(List<Object> interceptors) {
        interceptors.add((Object)new SkipPathExtensionContentNegotiation());
    }

    private static final class SkipPathExtensionContentNegotiation
    extends HandlerInterceptorAdapter {
        private static final String SKIP_ATTRIBUTE = PathExtensionContentNegotiationStrategy.class.getName() + ".SKIP";

        private SkipPathExtensionContentNegotiation() {
        }

        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
            request.setAttribute(SKIP_ATTRIBUTE, (Object)Boolean.TRUE);
            return true;
        }
    }
}

